/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.bpmn2.xml.UserTaskHandler;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.services.task.impl.model.TaskDefImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@ApplicationScoped
public class HumanTaskGetInformationHandler
extends UserTaskHandler {
    private ProcessDescRepoHelper repositoryHelper;
    @Inject
    private ProcessDescriptionRepository repository;

    protected void readIoSpecification(Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        dataInputs.clear();
        dataOutputs.clear();
        Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
            }
            subNode = subNode.getNextSibling();
        }
        NamedNodeMap map = xmlNode.getParentNode().getAttributes();
        Node nodeName = map.getNamedItem("name");
        String name = nodeName.getNodeValue();
        TaskDefImpl task = new TaskDefImpl();
        task.setName(name);
        HashMap<String, String> inputParams = new HashMap<String, String>();
        for (Map.Entry<String, String> in : dataInputs.entrySet()) {
            inputParams.put(in.getKey(), in.getValue());
        }
        HashMap<String, String> outputParams = new HashMap<String, String>();
        for (Map.Entry<String, String> out : dataOutputs.entrySet()) {
            outputParams.put(out.getKey(), out.getValue());
        }
        String mainProcessId = this.repositoryHelper.getProcess().getId();
        this.repository.getProcessDesc(mainProcessId).getTasks().put(task.getName(), task);
        this.repository.getProcessDesc(mainProcessId).getTaskInputMappings().put(task.getName(), inputParams);
        this.repository.getProcessDesc(mainProcessId).getTaskOutputMappings().put(task.getName(), outputParams);
    }

    protected String readPotentialOwner(Node xmlNode, HumanTaskNode humanTaskNode) {
        String userOrGroup = xmlNode.getFirstChild().getFirstChild().getFirstChild().getTextContent();
        String mainProcessId = this.repositoryHelper.getProcess().getId();
        this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), userOrGroup);
        return userOrGroup;
    }

    public void setRepositoryHelper(ProcessDescRepoHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setRepository(ProcessDescriptionRepository repository) {
        this.repository = repository;
    }
}

