/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.fusesource.camel.component.sap.SapIDocDestinationEndpoint;
import org.fusesource.camel.component.sap.SapQueuedIDocDestinationComponent;
import org.fusesource.camel.component.sap.SapQueuedIDocProducer;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-qidoc-destination", syntax="sap-qidoc-destination:destination")
public class SapQueuedIDocDestinationEndpoint
extends SapIDocDestinationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapQueuedIDocDestinationEndpoint.class);
    protected String queueName;

    public SapQueuedIDocDestinationEndpoint() {
    }

    public SapQueuedIDocDestinationEndpoint(String endpointUri, SapQueuedIDocDestinationComponent component) {
        super(endpointUri, (Component)component);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Document createDocument() throws Exception {
        try {
            return IDocUtil.createDocument(this.getIDocRepository(), this.getIdocType(), this.getIdocTypeExtension(), this.getSystemRelease(), this.getApplicationRelease());
        }
        catch (Exception e) {
            throw new Exception("Failed to get Document from endpoint", e);
        }
    }

    public Producer createProducer() throws Exception {
        LOG.debug("Created producer for endpoint '" + this.getEndpointUri() + "'");
        return new SapQueuedIDocProducer(this);
    }
}

