/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Converter;
import org.eclipse.emf.ecore.EObject;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.model.idoc.impl.DocumentImpl;
import org.fusesource.camel.component.sap.util.Util;

@Converter
public enum DocumentConverter {
    INSTANCE;


    @Converter
    public static Document toDocument(String string) {
        try {
            EObject eObject = Util.unmarshal(string);
            if (DocumentImpl.class.isInstance(eObject)) {
                return (DocumentImpl)eObject;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Converter
    public static Document toDocument(InputStream in) {
        try {
            EObject eObject = Util.fromInputStream(in);
            if (DocumentImpl.class.isInstance(eObject)) {
                return (DocumentImpl)eObject;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Converter
    public static Document toDocument(byte[] byteArray) {
        try {
            EObject eObject = Util.unmarshal(new String(byteArray));
            if (DocumentImpl.class.isInstance(eObject)) {
                return (DocumentImpl)eObject;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Converter
    public static String toString(DocumentImpl document) {
        try {
            return Util.marshal(document);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Converter
    public static OutputStream toOutputStream(DocumentImpl document) {
        try {
            return Util.toOutputStream(document);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Converter
    public static InputStream toInputStream(DocumentImpl document) {
        try {
            return Util.toInputStream(document);
        }
        catch (IOException e) {
            return null;
        }
    }
}

