/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.dozer.classmap.MappingFileData;
import org.dozer.config.BeanContainer;
import org.dozer.loader.MappingsSource;
import org.dozer.loader.xml.MappingStreamReader;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFileReader
implements MappingsSource<URL> {
    private final Logger log = LoggerFactory.getLogger(MappingFileReader.class);
    private final MappingStreamReader streamReader;

    public MappingFileReader(XMLParserFactory parserFactory) {
        this.streamReader = new MappingStreamReader(parserFactory);
    }

    @Override
    public MappingFileData read(String fileName) {
        DozerClassLoader classLoader = BeanContainer.getInstance().getClassLoader();
        URL url = classLoader.loadResource(fileName);
        return this.read(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappingFileData read(URL url) {
        MappingFileData result = null;
        InputStream stream = null;
        try {
            stream = url.openStream();
            result = this.streamReader.read(stream);
        }
        catch (IOException e) {
            this.log.error("Error while loading dozer mapping file url: [" + url + "]", (Throwable)e);
            MappingUtils.throwMappingException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                MappingUtils.throwMappingException(e);
            }
        }
        return result;
    }
}

