/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.ActivityGenerator;
import org.apache.ode.bpel.compiler.AssignGenerator;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.DefaultResourceFinder;
import org.apache.ode.bpel.compiler.ExpressionValidatorFactory;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.WSDLLocatorImpl;
import org.apache.ode.bpel.compiler.WSDLRegistry;
import org.apache.ode.bpel.compiler.WsdlFinderXMLEntityResolver;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompileListener;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.api.ExpressionValidator;
import org.apache.ode.bpel.compiler.api.SourceLocation;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.BpelObject;
import org.apache.ode.bpel.compiler.bom.Catch;
import org.apache.ode.bpel.compiler.bom.CompensationHandler;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.CorrelationSet;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.compiler.bom.Expression11;
import org.apache.ode.bpel.compiler.bom.FaultHandler;
import org.apache.ode.bpel.compiler.bom.From;
import org.apache.ode.bpel.compiler.bom.Import;
import org.apache.ode.bpel.compiler.bom.LinkSource;
import org.apache.ode.bpel.compiler.bom.LinkTarget;
import org.apache.ode.bpel.compiler.bom.OnAlarm;
import org.apache.ode.bpel.compiler.bom.OnEvent;
import org.apache.ode.bpel.compiler.bom.PartnerLink;
import org.apache.ode.bpel.compiler.bom.PartnerLinkType;
import org.apache.ode.bpel.compiler.bom.Process;
import org.apache.ode.bpel.compiler.bom.Property;
import org.apache.ode.bpel.compiler.bom.PropertyAlias;
import org.apache.ode.bpel.compiler.bom.Scope;
import org.apache.ode.bpel.compiler.bom.ScopeActivity;
import org.apache.ode.bpel.compiler.bom.ScopeLikeActivity;
import org.apache.ode.bpel.compiler.bom.TerminationHandler;
import org.apache.ode.bpel.compiler.bom.Variable;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.WSDLFactory4BPEL;
import org.apache.ode.bpel.o.DebugInfo;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OAssign;
import org.apache.ode.bpel.o.OCatch;
import org.apache.ode.bpel.o.OCompensate;
import org.apache.ode.bpel.o.OCompensationHandler;
import org.apache.ode.bpel.o.OConstantExpression;
import org.apache.ode.bpel.o.OConstantVarType;
import org.apache.ode.bpel.o.OConstants;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OEventHandler;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.o.OExtVar;
import org.apache.ode.bpel.o.OFaultHandler;
import org.apache.ode.bpel.o.OFlow;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.ORethrow;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OSequence;
import org.apache.ode.bpel.o.OTerminationHandler;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.bpel.o.OXslSheet;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.ode.utils.xsd.XSUtils;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class BpelCompiler
implements CompilerContext {
    protected static final Log __log = LogFactory.getLog(BpelCompiler.class);
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private Process _processDef;
    private Date _generatedDate;
    private HashMap<Class, ActivityGenerator> _actGenerators = new HashMap();
    private boolean _supressJoinFailure = false;
    private boolean _atomicScope = false;
    private StructureStack _structureStack = new StructureStack();
    private Stack<OScope> _recoveryContextStack = new Stack();
    private List<OActivity> _compiledActivities = new ArrayList<OActivity>();
    private OProcess _oprocess;
    private ResourceFinder _resourceFinder;
    private WSDLRegistry _wsdlRegistry;
    private final List<CompilationMessage> _errors = new ArrayList<CompilationMessage>();
    private CompileListener _compileListener;
    private final HashMap<String, ExpressionCompiler> _expLanguageCompilers = new HashMap();
    private final HashMap<String, OExpressionLanguage> _expLanguages = new HashMap();
    private ExpressionValidatorFactory _expressionValidatorFactory = new ExpressionValidatorFactory(System.getProperties());
    private WSDLFactory4BPEL _wsdlFactory;
    private OExpressionLanguage _konstExprLang;
    private Map<QName, Node> _customProcessProperties;
    private URI _processURI;

    BpelCompiler(WSDLFactory4BPEL wsdlFactory) {
        this._wsdlFactory = wsdlFactory;
        this._wsdlRegistry = new WSDLRegistry(this);
    }

    public void addWsdlImport(URI from, URI wsdlImport, SourceLocation sloc) {
        Definition4BPEL def;
        try {
            WSDLReader r = this._wsdlFactory.newWSDLReader();
            WSDLLocatorImpl locator = new WSDLLocatorImpl(this._resourceFinder, this._resourceFinder.resolve(from, wsdlImport));
            def = (Definition4BPEL)r.readWSDL((WSDLLocator)locator);
        }
        catch (WSDLException e) {
            this.recoveredFromError(sloc, new CompilationException(__cmsgs.errWsdlParseError(e.getFaultCode(), e.getLocation(), e.getMessage())));
            throw new CompilationException(__cmsgs.errWsdlImportFailed(wsdlImport.toASCIIString(), e.getFaultCode()).setSource(sloc), (Throwable)e);
        }
        try {
            this._wsdlRegistry.addDefinition(def, this._resourceFinder, this._resourceFinder.resolve(from, wsdlImport));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Added WSDL Definition: " + wsdlImport));
            }
        }
        catch (CompilationException ce) {
            this.recoveredFromError(sloc, ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXsdImport(URI from, URI location, SourceLocation sloc) {
        URI resFrom = this._resourceFinder.resolve(from, location);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Adding XSD import from " + resFrom + " location " + location));
        }
        WsdlFinderXMLEntityResolver resolver = new WsdlFinderXMLEntityResolver(this._resourceFinder, location, new HashMap<URI, byte[]>(), true);
        try {
            byte[] data;
            InputStream xsdStream = this._resourceFinder.openResource(resFrom);
            try {
                data = StreamUtils.read((InputStream)xsdStream);
            }
            finally {
                xsdStream.close();
            }
            Map schemas = XSUtils.captureSchema((URI)resFrom, (byte[])data, (XMLEntityResolver)resolver);
            this._wsdlRegistry.addSchemas(schemas);
        }
        catch (XsdException e) {
            CompilationException ce = new CompilationException(__cmsgs.errInvalidImport(location.toString()));
            this.recoveredFromError(sloc, ce);
        }
        catch (MalformedURLException e) {
            CompilationException ce = new CompilationException(__cmsgs.errInvalidImport(location.toString()));
            this.recoveredFromError(sloc, ce);
        }
        catch (IOException e) {
            CompilationException ce = new CompilationException(__cmsgs.errInvalidImport(location.toString()));
            this.recoveredFromError(sloc, ce);
        }
    }

    public void setResourceFinder(ResourceFinder finder) {
        this._resourceFinder = finder == null ? new DefaultResourceFinder() : finder;
    }

    public void setCompileListener(CompileListener compileListener) {
        this._compileListener = compileListener;
    }

    public CompileListener getCompileListener() {
        return this._compileListener;
    }

    public void setCustomProperties(Map<QName, Node> customProperties) {
        this._customProcessProperties = customProperties;
    }

    public Process getProcessDef() {
        return this._processDef;
    }

    public PortType resolvePortType(QName portTypeName) {
        if (portTypeName == null) {
            throw new NullPointerException("Null portTypeName argument!");
        }
        PortType portType = this._wsdlRegistry.getPortType(portTypeName);
        if (portType == null) {
            throw new CompilationException(__cmsgs.errUndeclaredPortType(portTypeName));
        }
        return portType;
    }

    @Override
    public OLink resolveLink(String linkName) {
        OLink ret = null;
        Iterator<OActivity> i = this._structureStack.iterator();
        while (i.hasNext()) {
            OActivity oact = i.next();
            if (oact instanceof OFlow) {
                ret = ((OFlow)oact).getLocalLink(linkName);
            }
            if (ret == null) continue;
            return ret;
        }
        throw new CompilationException(__cmsgs.errUndeclaredLink(linkName));
    }

    @Override
    public OScope.Variable resolveVariable(String varName) {
        Iterator<OScope> i = this._structureStack.oscopeIterator();
        while (i.hasNext()) {
            OScope.Variable var = i.next().getLocalVariable(varName);
            if (var == null) continue;
            return var;
        }
        if (this._customProcessProperties == null || this._customProcessProperties.get(QName.valueOf(varName)) != null) {
            // empty if block
        }
        throw new CompilationException(__cmsgs.errUndeclaredVariable(varName));
    }

    @Override
    public List<OScope.Variable> getAccessibleVariables() {
        ArrayList<OScope.Variable> result = new ArrayList<OScope.Variable>();
        Iterator<OScope> i = this._structureStack.oscopeIterator();
        while (i.hasNext()) {
            result.addAll(i.next().variables.values());
        }
        return result;
    }

    @Override
    public OScope.Variable resolveMessageVariable(String inputVar) throws CompilationException {
        OScope.Variable var = this.resolveVariable(inputVar);
        if (!(var.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(inputVar));
        }
        return var;
    }

    @Override
    public OScope.Variable resolveMessageVariable(String inputVar, QName messageType) throws CompilationException {
        OScope.Variable var = this.resolveMessageVariable(inputVar);
        if (!((OMessageVarType)var.type).messageType.equals(messageType)) {
            throw new CompilationException(__cmsgs.errVariableTypeMismatch(var.name, messageType, ((OMessageVarType)var.type).messageType));
        }
        return var;
    }

    @Override
    public OProcess.OProperty resolveProperty(QName name) {
        for (OProcess.OProperty prop : this._oprocess.properties) {
            if (!prop.name.equals(name)) continue;
            return prop;
        }
        throw new CompilationException(__cmsgs.errUndeclaredProperty(name));
    }

    @Override
    public OProcess.OPropertyAlias resolvePropertyAlias(OScope.Variable variable, QName propertyName) {
        if (!(variable.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(variable.name));
        }
        OProcess.OProperty property = this.resolveProperty(propertyName);
        OProcess.OPropertyAlias alias = property.getAlias(variable.type);
        if (alias == null) {
            throw new CompilationException(__cmsgs.errUndeclaredPropertyAlias(variable.type.toString(), propertyName));
        }
        return alias;
    }

    @Override
    public OScope resolveCompensatableScope(final String scopeToCompensate) throws CompilationException {
        if (this._recoveryContextStack.isEmpty()) {
            throw new CompilationException(__cmsgs.errCompensateNAtoContext());
        }
        OScope recoveryContext = this._recoveryContextStack.peek();
        OScope scopeToComp = (OScope)CollectionsX.find_if((Collection)recoveryContext.compensatable, (MemberOfFunction)new MemberOfFunction<OScope>(){

            public boolean isMember(OScope o) {
                return o.name != null && o.name.equals(scopeToCompensate);
            }
        });
        if (scopeToComp == null) {
            throw new CompilationException(__cmsgs.errCompensateOfInvalidScope(scopeToCompensate));
        }
        return scopeToComp;
    }

    @Override
    public String getSourceLocation() {
        return this._processDef.getSource() == null ? null : this._processDef.getSource();
    }

    @Override
    public OScope.CorrelationSet resolveCorrelationSet(String csetName) {
        Iterator<OScope> i = this._structureStack.oscopeIterator();
        while (i.hasNext()) {
            OScope.CorrelationSet cset = i.next().getCorrelationSet(csetName);
            if (cset == null) continue;
            return cset;
        }
        throw new CompilationException(__cmsgs.errUndeclaredCorrelationSet(csetName));
    }

    public OMessageVarType resolveMessageType(QName messageType) {
        OMessageVarType msgType = (OMessageVarType)this._oprocess.messageTypes.get(messageType);
        if (msgType == null) {
            Message msg = this._wsdlRegistry.getMessage(messageType);
            if (msg == null) {
                throw new CompilationException(__cmsgs.errUndeclaredMessage(messageType.getLocalPart(), messageType.getNamespaceURI()));
            }
            ArrayList parts = new ArrayList();
            CollectionsX.transform(parts, (Collection)msg.getOrderedParts(null), (UnaryFunction)new UnaryFunction<Part, OMessageVarType.Part>(){

                public OMessageVarType.Part apply(Part part) {
                    Object partType = part.getElementName() != null ? BpelCompiler.this.resolveElementType(part.getElementName()) : BpelCompiler.this.resolveXsdType(part.getTypeName());
                    OMessageVarType.Part opart = new OMessageVarType.Part(BpelCompiler.this._oprocess, part.getName(), (OVarType)partType);
                    opart.debugInfo = BpelCompiler.this.createDebugInfo(BpelCompiler.this._processDef, "Message Variable Part: " + part.getName());
                    return opart;
                }
            });
            msgType = new OMessageVarType(this._oprocess, msg.getQName(), parts);
            msgType.debugInfo = this.createDebugInfo(this._processDef, "Message Type: " + msg.getQName());
            this._oprocess.messageTypes.put(msg.getQName(), msgType);
        }
        return msgType;
    }

    @Override
    public OXsdTypeVarType resolveXsdType(QName typeName) throws CompilationException {
        OXsdTypeVarType type = (OXsdTypeVarType)this._oprocess.xsdTypes.get(typeName);
        if (type == null) {
            __log.debug((Object)("Resolving XSD type " + typeName));
            SchemaModel model = null;
            try {
                model = this._wsdlRegistry.getSchemaModel();
            }
            catch (IllegalArgumentException iaa) {
                // empty catch block
            }
            if (model == null || !model.knowsSchemaType(typeName)) {
                throw new CompilationException(__cmsgs.errUndeclaredXsdType(typeName));
            }
            type = new OXsdTypeVarType(this._oprocess);
            type.debugInfo = this.createDebugInfo(this._processDef, "XSD Type: " + typeName);
            type.xsdType = typeName;
            type.simple = this._wsdlRegistry.getSchemaModel().isSimpleType(typeName);
            this._oprocess.xsdTypes.put(typeName, type);
        }
        return type;
    }

    @Override
    public OMessageVarType.Part resolvePart(OScope.Variable var, String partname) {
        if (!(var.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(var.name));
        }
        OMessageVarType msgVarType = (OMessageVarType)var.type;
        OMessageVarType.Part part = (OMessageVarType.Part)msgVarType.parts.get(partname);
        if (part == null) {
            throw new CompilationException(__cmsgs.errUndeclaredMessagePart(var.name, ((OMessageVarType)var.type).messageType, partname));
        }
        return part;
    }

    @Override
    public OMessageVarType.Part resolveHeaderPart(OScope.Variable var, String partname) {
        if (!(var.type instanceof OMessageVarType)) {
            throw new CompilationException(__cmsgs.errMessageVariableRequired(var.name));
        }
        OMessageVarType msgVarType = (OMessageVarType)var.type;
        return (OMessageVarType.Part)msgVarType.parts.get(partname);
    }

    public PartnerLinkType resolvePartnerLinkType(QName partnerLinkType) {
        PartnerLinkType plinkType = this._wsdlRegistry.getPartnerLinkType(partnerLinkType);
        if (plinkType == null) {
            throw new CompilationException(__cmsgs.errUndeclaredPartnerLinkType(partnerLinkType));
        }
        return plinkType;
    }

    @Override
    public OPartnerLink resolvePartnerLink(String name) {
        Iterator<OScope> i = this._structureStack.oscopeIterator();
        while (i.hasNext()) {
            OPartnerLink oplink = i.next().getLocalPartnerLink(name);
            if (oplink == null) continue;
            return oplink;
        }
        throw new CompilationException(__cmsgs.errUndeclaredPartnerLink(name));
    }

    @Override
    public Operation resolvePartnerRoleOperation(OPartnerLink partnerLink, final String operationName) {
        if (partnerLink.partnerRolePortType == null) {
            throw new CompilationException(__cmsgs.errPartnerLinkDoesNotDeclarePartnerRole(partnerLink.getName()));
        }
        Operation found = (Operation)CollectionsX.find_if((Collection)partnerLink.partnerRolePortType.getOperations(), (MemberOfFunction)new MemberOfFunction<Operation>(){

            public boolean isMember(Operation o) {
                if (!(o.getInput() != null && o.getInput().getMessage() != null || o.getOutput() != null && o.getOutput().getMessage() != null)) {
                    return false;
                }
                return o.getName().equals(operationName);
            }
        });
        if (found == null) {
            throw new CompilationException(__cmsgs.errUndeclaredOperation(partnerLink.partnerRolePortType.getQName(), operationName));
        }
        return found;
    }

    @Override
    public Operation resolveMyRoleOperation(OPartnerLink partnerLink, final String operationName) {
        if (partnerLink.myRolePortType == null) {
            throw new CompilationException(__cmsgs.errPartnerLinkDoesNotDeclareMyRole(partnerLink.getName()));
        }
        Operation found = (Operation)CollectionsX.find_if((Collection)partnerLink.myRolePortType.getOperations(), (MemberOfFunction)new MemberOfFunction<Operation>(){

            public boolean isMember(Operation o) {
                if (!(o.getInput() != null && o.getInput().getMessage() != null || o.getOutput() != null && o.getOutput().getMessage() != null)) {
                    return false;
                }
                return o.getName().equals(operationName);
            }
        });
        if (found == null) {
            throw new CompilationException(__cmsgs.errUndeclaredOperation(partnerLink.myRolePortType.getQName(), operationName));
        }
        return found;
    }

    @Override
    public OExpression constantExpr(boolean value) {
        OConstantExpression ce = new OConstantExpression(this._oprocess, (Object)(value ? Boolean.TRUE : Boolean.FALSE));
        ce.debugInfo = this.createDebugInfo(this._processDef, "Constant Boolean Expression: " + value);
        ce.expressionLanguage = this._konstExprLang;
        return ce;
    }

    @Override
    public OLValueExpression compileLValueExpr(Expression expression) throws CompilationException {
        return this.compileLValueExpr(expression, null, null, new Object[1]);
    }

    @Override
    public OLValueExpression compileLValueExpr(Expression expression, OVarType rootNodeType, Object requestedResultType, Object[] resultType) throws CompilationException {
        return (OLValueExpression)this.compileExpr(expression, false, true, rootNodeType, requestedResultType, resultType);
    }

    @Override
    public OExpression compileJoinCondition(Expression expression) throws CompilationException {
        return this.compileExpr(expression, true, false, null, null, new Object[1]);
    }

    @Override
    public OExpression compileExpr(Expression expression) throws CompilationException {
        return this.compileExpr(expression, null, null, new Object[1]);
    }

    @Override
    public OExpression compileExpr(Expression expression, OVarType rootNodeType, Object requestedResultType, Object[] resultType) throws CompilationException {
        return this.compileExpr(expression, false, false, rootNodeType, requestedResultType, resultType);
    }

    @Override
    public OExpression compileExpr(String expr, NSContext nc) {
        BpelObject cur = this._structureStack.topSource();
        return this.compileExpr(new Expression11(cur.getElement(), cur.getElement().getOwnerDocument().createTextNode(expr)), false, false, null, null, new Object[1]);
    }

    private OExpression compileExpr(Expression expression, boolean isJoinCondition, boolean isLValue, OVarType rootNodeType, Object requestedResultType, Object[] resultType) {
        String expLang = this.getExpressionLanguage(expression);
        ExpressionCompiler ec = this.findExpLangCompiler(expLang);
        ec.setCompilerContext(this);
        ExpressionValidator ev = this._expressionValidatorFactory.getValidator();
        try {
            OExpression oexpr;
            if (isJoinCondition) {
                oexpr = ec.compileJoinCondition(expression);
            } else {
                oexpr = ec.compile(expression);
                resultType[0] = ev.validate(expression, rootNodeType, requestedResultType);
            }
            oexpr.debugInfo = this.createDebugInfo(expression, expression.toString());
            OExpressionLanguage expLanguage = this._expLanguages.get(expLang);
            if (expLanguage == null) {
                expLanguage = new OExpressionLanguage(this._oprocess, ec.getProperties());
                expLanguage.debugInfo = this.createDebugInfo(this._processDef, "Expression Language: " + expLang);
                expLanguage.expressionLanguageUri = expLang;
                this._expLanguages.put(expLang, expLanguage);
                this._oprocess.expressionLanguages.add(expLanguage);
            }
            oexpr.expressionLanguage = expLanguage;
            ec.setCompilerContext(null);
            return oexpr;
        }
        catch (CompilationException ce) {
            if (ce.getCompilationMessage().source == null) {
                ce.getCompilationMessage().setSource(expression);
            }
            throw ce;
        }
    }

    @Override
    public OProcess getOProcess() throws CompilationException {
        return this._oprocess;
    }

    @Override
    public void recoveredFromError(SourceLocation where, CompilationException bce) throws CompilationException {
        if (bce.getCompilationMessage().source == null) {
            bce.getCompilationMessage().source = where;
        }
        if (this._compileListener == null) {
            switch (bce.getCompilationMessage().severity) {
                case 0: {
                    if (!__log.isInfoEnabled()) break;
                    __log.info((Object)bce.toErrorMessage());
                    break;
                }
                case 1: {
                    if (!__log.isWarnEnabled()) break;
                    __log.warn((Object)bce.toErrorMessage());
                    break;
                }
                case 2: {
                    if (!__log.isErrorEnabled()) break;
                    __log.error((Object)bce.toErrorMessage());
                }
            }
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)bce.toErrorMessage(), (Throwable)bce);
            }
            this._compileListener.onCompilationMessage(bce.getCompilationMessage());
        }
        this._errors.add(bce.getCompilationMessage());
    }

    public static long getVersion(String dirName) {
        try {
            if (dirName.lastIndexOf("-") != -1) {
                return Long.parseLong(dirName.substring(dirName.lastIndexOf("-") + 1));
            }
        }
        catch (Throwable t) {
            __log.debug((Object)("Unable to parse version '" + dirName + "'"), t);
        }
        return 0L;
    }

    public OProcess compile(final Process process, ResourceFinder rf, long version) throws CompilationException {
        Definition4BPEL[] defs;
        if (process == null) {
            throw new NullPointerException("Null process parameter");
        }
        this.setResourceFinder(rf);
        this._processURI = process.getURI();
        this._processDef = process;
        this._generatedDate = new Date();
        this._structureStack.clear();
        String bpelVersionUri = null;
        switch (process.getBpelVersion()) {
            case BPEL11: {
                bpelVersionUri = "http://schemas.xmlsoap.org/ws/2003/03/business-process/";
                break;
            }
            case BPEL20_DRAFT: {
                bpelVersionUri = "http://schemas.xmlsoap.org/ws/2004/03/business-process/";
                break;
            }
            case BPEL20: {
                bpelVersionUri = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
                break;
            }
            default: {
                throw new IllegalStateException("Bad bpel version: " + (Object)((Object)process.getBpelVersion()));
            }
        }
        this._oprocess = new OProcess(bpelVersionUri);
        this._oprocess.guid = null;
        this._oprocess.constants = this.makeConstants();
        this._oprocess.debugInfo = this.createDebugInfo(process, "process");
        if (process.getTargetNamespace() == null) {
            this._oprocess.targetNamespace = "--UNSPECIFIED--";
            this.recoveredFromError(process, new CompilationException(__cmsgs.errProcessNamespaceNotSpecified()));
        } else {
            this._oprocess.targetNamespace = this._processDef.getTargetNamespace();
        }
        if (process.getName() == null) {
            this._oprocess.processName = "--UNSPECIFIED--";
            this.recoveredFromError(process, new CompilationException(__cmsgs.errProcessNameNotSpecified()));
        } else {
            this._oprocess.processName = this._processDef.getName();
        }
        this._oprocess.compileDate = this._generatedDate;
        this._konstExprLang = new OExpressionLanguage(this._oprocess, null);
        this._konstExprLang.debugInfo = this.createDebugInfo(this._processDef, "Constant Value Expression Language");
        this._konstExprLang.expressionLanguageUri = "uri:www.fivesight.com/konstExpression";
        this._konstExprLang.properties.put("runtime-class", "org.apache.ode.bpel.runtime.explang.konst.KonstExpressionLanguageRuntimeImpl");
        this._oprocess.expressionLanguages.add(this._konstExprLang);
        for (Import imprt : this._processDef.getImports()) {
            try {
                this.compile(this._processURI, imprt);
            }
            catch (CompilationException bce) {
                this.recoveredFromError(imprt, bce);
            }
        }
        this._expressionValidatorFactory.getValidator().bpelImportsLoaded(this._processDef, this);
        switch (this._processDef.getSuppressJoinFailure()) {
            case NO: 
            case NOTSET: {
                this._supressJoinFailure = false;
                break;
            }
            case YES: {
                this._supressJoinFailure = true;
            }
        }
        for (Definition4BPEL def : defs = this._wsdlRegistry.getDefinitions()) {
            for (Property property : def.getProperties()) {
                this.compile(property);
            }
        }
        for (Definition4BPEL def1 : defs) {
            for (PropertyAlias propertyAlias : def1.getPropertyAliases()) {
                this.compile(propertyAlias);
            }
        }
        OScope procesScope = new OScope(this._oprocess, null);
        procesScope.name = "__PROCESS_SCOPE:" + process.getName();
        procesScope.debugInfo = this.createDebugInfo(process, null);
        this._oprocess.procesScope = this.compileScope(procesScope, process, new Runnable(){

            @Override
            public void run() {
                if (process.getRootActivity() == null) {
                    throw new CompilationException(__cmsgs.errNoRootActivity());
                }
                if (BpelCompiler.this._customProcessProperties != null) {
                    for (Map.Entry customVar : BpelCompiler.this._customProcessProperties.entrySet()) {
                        OScope oscope = BpelCompiler.this._structureStack.topScope();
                        OConstantVarType varType = new OConstantVarType(BpelCompiler.this._oprocess, (Node)customVar.getValue());
                        OScope.Variable ovar = new OScope.Variable(BpelCompiler.this._oprocess, (OVarType)varType);
                        ovar.name = ((QName)customVar.getKey()).getLocalPart();
                        ovar.declaringScope = oscope;
                        ovar.debugInfo = BpelCompiler.this.createDebugInfo(null, "Process custom property variable");
                        oscope.addLocalVariable(ovar);
                        if (!__log.isDebugEnabled()) continue;
                        __log.debug((Object)("Compiled custom property variable " + ovar));
                    }
                }
                ((BpelCompiler)BpelCompiler.this)._structureStack.topScope().activity = BpelCompiler.this.compile(process.getRootActivity());
            }
        });
        assert (this._structureStack.size() == 0);
        boolean hasErrors = false;
        StringBuffer sb = new StringBuffer();
        for (CompilationMessage msg : this._errors) {
            if (msg.severity < 2) continue;
            hasErrors = true;
            sb.append('\t');
            sb.append(msg.toErrorString());
            sb.append('\n');
        }
        XslTransformHandler.getInstance().clearXSLSheets(this._oprocess.getQName());
        this._expressionValidatorFactory.getValidator().bpelCompilationCompleted(this._processDef);
        if (hasErrors) {
            throw new CompilationException(__cmsgs.errCompilationErrors(this._errors.size(), sb.toString()));
        }
        String digest = "version:" + version + ";" + this._oprocess.digest();
        this._oprocess.guid = GUID.makeGUID((String)digest);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled process digest: " + digest + "\nguid: " + this._oprocess.guid));
        }
        return this._oprocess;
    }

    private OConstants makeConstants() {
        OConstants constants = new OConstants(this._oprocess);
        constants.qnConflictingReceive = new QName(this.getBpwsNamespace(), "conflictingReceive");
        constants.qnConflictingRequest = new QName(this.getBpwsNamespace(), "conflictingRequest");
        constants.qnCorrelationViolation = new QName(this.getBpwsNamespace(), "correlationViolation");
        constants.qnForcedTermination = new QName(this.getBpwsNamespace(), "forcedTermination");
        constants.qnJoinFailure = new QName(this.getBpwsNamespace(), "joinFailure");
        constants.qnMismatchedAssignmentFailure = new QName(this.getBpwsNamespace(), "mismatchedAssignment");
        constants.qnMissingReply = new QName(this.getBpwsNamespace(), "missingReply");
        constants.qnMissingRequest = new QName(this.getBpwsNamespace(), "missingRequest");
        constants.qnSelectionFailure = new QName(this.getBpwsNamespace(), "selectionFailure");
        constants.qnUninitializedVariable = new QName(this.getBpwsNamespace(), "uninitializedVariable");
        constants.qnXsltInvalidSource = new QName(this.getBpwsNamespace(), "xsltInvalidSource");
        constants.qnSubLanguageExecutionFault = new QName(this.getBpwsNamespace(), "subLanguageExecutionFault");
        constants.qnUninitializedPartnerRole = new QName(this.getBpwsNamespace(), "uninitializedPartnerRole");
        constants.qnForEachCounterError = new QName(this.getBpwsNamespace(), "forEachCounterError");
        constants.qnInvalidBranchCondition = new QName(this.getBpwsNamespace(), "invalidBranchCondition");
        constants.qnInvalidExpressionValue = new QName(this.getBpwsNamespace(), "invalidExpressionValue");
        constants.qnRetiredProcess = new QName(this.getOdeNamespace(), "retiredProcess");
        constants.qnTooManyInstances = new QName(this.getOdeNamespace(), "tooManyInstances");
        constants.qnUnknownFault = new QName(this.getOdeNamespace(), "unknownFault");
        constants.qnTooManyProcesses = new QName(this.getOdeNamespace(), "tooManyProcesses");
        constants.qnTooHugeProcesses = new QName(this.getOdeNamespace(), "tooHugeProcesses");
        return constants;
    }

    private String getOdeNamespace() {
        return Namespaces.ODE_EXTENSION_NS;
    }

    private void compile(URI current, Import imprt) {
        block7: {
            try {
                if (imprt.getImportType() == null) {
                    throw new CompilationException(__cmsgs.errUnspecifiedImportType().setSource(imprt));
                }
                if (imprt.getLocation() == null) {
                    throw new CompilationException(__cmsgs.errMissingImportLocation().setSource(imprt));
                }
                if ("http://schemas.xmlsoap.org/wsdl/".equals(imprt.getImportType())) {
                    this.addWsdlImport(current, imprt.getLocation(), imprt);
                    break block7;
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(imprt.getImportType())) {
                    this.addXsdImport(current, imprt.getLocation(), imprt);
                    break block7;
                }
                throw new CompilationException(__cmsgs.errUnknownImportType(imprt.getImportType()).setSource(imprt));
            }
            catch (CompilationException ce) {
                if (ce.getCompilationMessage().source == null) {
                    ce.getCompilationMessage().setSource(imprt);
                }
                throw ce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OActivity compile(Activity source) {
        OActivity compiled;
        if (source == null) {
            throw new IllegalArgumentException("null-argument");
        }
        boolean previousSupressJoinFailure = this._supressJoinFailure;
        switch (source.getSuppressJoinFailure()) {
            case NO: {
                this._supressJoinFailure = false;
                break;
            }
            case YES: {
                this._supressJoinFailure = true;
            }
        }
        try {
            compiled = source instanceof ScopeLikeActivity ? this.compileSLC((ScopeLikeActivity)source, new OScope.Variable[0]) : this.compileActivity(true, source);
            compiled.suppressJoinFailure = this._supressJoinFailure;
        }
        finally {
            this._supressJoinFailure = previousSupressJoinFailure;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled activity " + compiled));
        }
        return compiled;
    }

    private OCompensate createDefaultCompensateActivity(BpelObject source, String desc) {
        OCompensate activity = new OCompensate(this._oprocess, this.getCurrent());
        activity.name = "__autoGenCompensate:" + this._structureStack.topScope().name;
        activity.debugInfo = this.createDebugInfo(source, desc);
        return activity;
    }

    @Override
    public OScope compileSLC(final ScopeLikeActivity source, final OScope.Variable[] variables) {
        final OScope implicitScope = new OScope(this._oprocess, this.getCurrent());
        implicitScope.implicitScope = true;
        implicitScope.name = this.createName(source, "implicit-scope");
        implicitScope.debugInfo = this.createDebugInfo(source, "Scope-like construct " + source);
        this.compileScope(implicitScope, source.getScope(), new Runnable(){

            @Override
            public void run() {
                BpelCompiler.this.compileLinks(source);
                for (OScope.Variable v : variables) {
                    v.declaringScope = implicitScope;
                    implicitScope.addLocalVariable(v);
                }
                if (source instanceof ScopeActivity) {
                    Activity scopeChild = ((ScopeActivity)source).getChildActivity();
                    if (scopeChild == null) {
                        throw new CompilationException(__cmsgs.errEmptyScope().setSource(source));
                    }
                    implicitScope.activity = BpelCompiler.this.compile(scopeChild);
                } else {
                    implicitScope.activity = BpelCompiler.this.compileActivity(false, source);
                }
            }
        });
        return implicitScope;
    }

    private OActivity compileActivity(final boolean doLinks, final Activity source) {
        final ActivityGenerator actgen = this.findActivityGen(source);
        final OActivity oact = actgen.newInstance(source);
        oact.name = this.createName(source, "activity");
        oact.debugInfo = this.createDebugInfo(source, "Activity body for " + source);
        this._compiledActivities.add(oact);
        this.compile(oact, source, new Runnable(){

            @Override
            public void run() {
                if (doLinks) {
                    BpelCompiler.this.compileLinks(source);
                }
                actgen.compile(oact, source);
            }
        });
        return oact;
    }

    private void compileLinks(Activity source) {
        for (LinkSource ls : source.getLinkSources()) {
            this.compileLinkSource(ls);
        }
        for (LinkTarget lt : source.getLinkTargets()) {
            this.compileLinkTarget(lt);
        }
        this._structureStack.topActivity().joinCondition = source.getJoinCondition() == null || source.getLinkTargets().isEmpty() ? null : this.compileJoinCondition(source.getJoinCondition());
    }

    private String createName(Activity source, String type) {
        if (source.getName() != null) {
            return source.getName();
        }
        return source.getType().getLocalPart() + "-" + type + "-line-" + source.getLineNo();
    }

    private OProcess.OProperty compile(Property property) {
        OProcess.OProperty oproperty = new OProcess.OProperty(this._oprocess);
        oproperty.name = property.getName();
        oproperty.debugInfo = this.createDebugInfo(this._processDef, "Property " + property.getName());
        if (!this._wsdlRegistry.getSchemaModel().isSimpleType(property.getPropertyType())) {
            throw new CompilationException(__cmsgs.errPropertyDeclaredWithComplexType(property.getName(), property.getPropertyType()).setSource(property));
        }
        this._oprocess.properties.add(oproperty);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled property " + oproperty));
        }
        return oproperty;
    }

    private OProcess.OPropertyAlias compile(PropertyAlias src) {
        OMessageVarType messageType;
        OProcess.OProperty property = this.resolveProperty(src.getPropertyName());
        OProcess.OPropertyAlias alias = new OProcess.OPropertyAlias(this._oprocess);
        alias.debugInfo = this.createDebugInfo(this._processDef, "PropertyAlias " + src.getPropertyName() + " for " + src.getMessageType());
        if (src.getMessageType() == null) {
            throw new CompilationException(__cmsgs.errAliasUndeclaredMessage(src.getPropertyName(), src.getQuery().getPath()));
        }
        OMessageVarType rootNodeType = messageType = this.resolveMessageType(src.getMessageType());
        alias.varType = messageType;
        if (src.getPart() != null) {
            alias.part = (OMessageVarType.Part)messageType.parts.get(src.getPart());
            if (alias.part == null) {
                throw new CompilationException(__cmsgs.errUnknownPartInAlias(src.getPart(), messageType.messageType.toString()));
            }
            rootNodeType = alias.part.type;
        }
        if (src.getQuery() != null) {
            alias.location = this.compileExpr(src.getQuery(), (OVarType)rootNodeType, null, new Object[1]);
        }
        property.aliases.add(alias);
        alias.debugInfo = this.createDebugInfo(this._processDef, src.getMessageType() + " --> " + src.getPropertyName());
        return alias;
    }

    private void compileLinkTarget(LinkTarget target) {
        OLink ol = this.resolveLink(target.getLinkName());
        assert (ol != null);
        ol.debugInfo = this.createDebugInfo(target, target.toString());
        if (ol.target != null) {
            throw new CompilationException(__cmsgs.errDuplicateLinkTarget(target.getLinkName()).setSource(target));
        }
        ol.target = this._structureStack.topActivity();
        this._structureStack.topActivity().targetLinks.add(ol);
    }

    private void compileLinkSource(LinkSource linksrc) {
        OLink ol = this.resolveLink(linksrc.getLinkName());
        assert (ol != null);
        ol.debugInfo = this.createDebugInfo(linksrc, linksrc.toString());
        if (ol.source != null) {
            throw new CompilationException(__cmsgs.errDuplicateLinkSource(linksrc.getLinkName()).setSource(linksrc));
        }
        ol.source = this._structureStack.topActivity();
        ol.transitionCondition = linksrc.getTransitionCondition() == null ? this.constantExpr(true) : this.compileExpr(linksrc.getTransitionCondition());
        this._structureStack.topActivity().sourceLinks.add(ol);
        this._structureStack.topActivity().outgoingLinks.add(ol);
    }

    private void compile(PartnerLink plink) {
        OPartnerLink oplink = new OPartnerLink(this._oprocess);
        oplink.debugInfo = this.createDebugInfo(plink, plink.toString());
        try {
            QName portType;
            PartnerLinkType plinkType = this.resolvePartnerLinkType(plink.getPartnerLinkType());
            oplink.partnerLinkType = plinkType.getName();
            oplink.name = plink.getName();
            oplink.initializePartnerRole = plink.isInitializePartnerRole();
            if (plink.hasMyRole()) {
                PartnerLinkType.Role myRole = plinkType.getRole(plink.getMyRole());
                if (myRole == null) {
                    throw new CompilationException(__cmsgs.errUndeclaredRole(plink.getMyRole(), plinkType.getName()));
                }
                oplink.myRoleName = myRole.getName();
                portType = myRole.getPortType();
                if (portType == null) {
                    throw new CompilationException(__cmsgs.errMissingMyRolePortType(myRole.getPortType(), plink.getMyRole(), plinkType.getName()));
                }
                oplink.myRolePortType = this.resolvePortType(portType);
            }
            if (plink.isInitializePartnerRole() && !plink.hasPartnerRole()) {
                throw new CompilationException(__cmsgs.errPartnerLinkNoPartnerRoleButInitialize(plink.getName()));
            }
            if (plink.hasPartnerRole()) {
                PartnerLinkType.Role partnerRole = plinkType.getRole(plink.getPartnerRole());
                if (partnerRole == null) {
                    throw new CompilationException(__cmsgs.errUndeclaredRole(plink.getPartnerRole(), plinkType.getName()));
                }
                oplink.partnerRoleName = partnerRole.getName();
                portType = partnerRole.getPortType();
                if (portType == null) {
                    throw new CompilationException(__cmsgs.errMissingPartnerRolePortType(partnerRole.getPortType(), plink.getPartnerRole(), plinkType.getName()));
                }
                oplink.partnerRolePortType = this.resolvePortType(portType);
            }
            oplink.declaringScope = this._structureStack.topScope();
            if (oplink.declaringScope.partnerLinks.containsKey(oplink.name)) {
                throw new CompilationException(__cmsgs.errDuplicatePartnerLinkDecl(oplink.name));
            }
            oplink.declaringScope.partnerLinks.put(oplink.name, oplink);
            this._oprocess.allPartnerLinks.add(oplink);
        }
        catch (CompilationException ce) {
            ce.getCompilationMessage().setSource(plink);
            throw ce;
        }
    }

    private void compile(CorrelationSet cset) {
        OScope oscope = this._structureStack.topScope();
        OScope.CorrelationSet ocset = new OScope.CorrelationSet(this._oprocess);
        ocset.name = cset.getName();
        ocset.declaringScope = oscope;
        ocset.debugInfo = this.createDebugInfo(cset, cset.toString());
        QName[] setprops = cset.getProperties();
        for (int j = 0; j < setprops.length; ++j) {
            ocset.properties.add(this.resolveProperty(setprops[j]));
        }
        oscope.addCorrelationSet(ocset);
    }

    @Override
    public OActivity getCurrent() {
        return this._structureStack.topActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(OActivity context, BpelObject source, Runnable run) {
        OScope topScope;
        OActivity popped;
        block9: {
            OActivity newtop;
            DefaultActivityGenerator.defaultExtensibilityElements(context, source);
            this._structureStack.push(context, source);
            try {
                run.run();
                popped = this._structureStack.pop();
                newtop = this._structureStack.topActivity();
                topScope = this._structureStack.topScope();
                if (newtop == null) break block9;
                newtop.nested.add(popped);
            }
            catch (Throwable throwable) {
                OActivity popped2 = this._structureStack.pop();
                OActivity newtop2 = this._structureStack.topActivity();
                OScope topScope2 = this._structureStack.topScope();
                if (newtop2 != null) {
                    newtop2.nested.add(popped2);
                    newtop2.incomingLinks.addAll(popped2.incomingLinks);
                    if (newtop2 instanceof OFlow) {
                        newtop2.incomingLinks.removeAll(((OFlow)newtop2).localLinks);
                    }
                    newtop2.outgoingLinks.addAll(popped2.outgoingLinks);
                    if (newtop2 instanceof OFlow) {
                        newtop2.outgoingLinks.removeAll(((OFlow)newtop2).localLinks);
                    }
                    newtop2.variableRd.addAll(popped2.variableRd);
                    newtop2.variableWr.addAll(popped2.variableWr);
                }
                if (topScope2 != null && popped2 instanceof OScope) {
                    topScope2.compensatable.add((OScope)popped2);
                }
                throw throwable;
            }
            newtop.incomingLinks.addAll(popped.incomingLinks);
            if (newtop instanceof OFlow) {
                newtop.incomingLinks.removeAll(((OFlow)newtop).localLinks);
            }
            newtop.outgoingLinks.addAll(popped.outgoingLinks);
            if (newtop instanceof OFlow) {
                newtop.outgoingLinks.removeAll(((OFlow)newtop).localLinks);
            }
            newtop.variableRd.addAll(popped.variableRd);
            newtop.variableWr.addAll(popped.variableWr);
        }
        if (topScope != null && popped instanceof OScope) {
            topScope.compensatable.add((OScope)popped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OScope compileScope(final OScope oscope, final Scope src, final Runnable init) {
        if (oscope.name == null) {
            throw new IllegalArgumentException("Unnamed scope:" + src);
        }
        oscope.debugInfo = this.createDebugInfo(src, src.toString());
        boolean previousAtomicScope = this._atomicScope;
        if (src.getAtomicScope() != null) {
            boolean newValue = src.getAtomicScope();
            if (this._atomicScope) {
                throw new CompilationException(__cmsgs.errAtomicScopeNesting(newValue));
            }
            oscope.atomicScope = this._atomicScope = newValue;
        }
        try {
            this.compile((OActivity)oscope, src, new Runnable(){

                @Override
                public void run() {
                    for (Variable var : src.getVariables()) {
                        try {
                            BpelCompiler.this.compile(var);
                        }
                        catch (CompilationException ce) {
                            BpelCompiler.this.recoveredFromError(var, ce);
                        }
                    }
                    for (CorrelationSet cset : src.getCorrelationSetDecls()) {
                        try {
                            BpelCompiler.this.compile(cset);
                        }
                        catch (CompilationException ce) {
                            BpelCompiler.this.recoveredFromError(cset, ce);
                        }
                    }
                    for (PartnerLink plink : src.getPartnerLinks()) {
                        try {
                            BpelCompiler.this.compile(plink);
                        }
                        catch (CompilationException ce) {
                            BpelCompiler.this.recoveredFromError(plink, ce);
                        }
                    }
                    if (!src.getEvents().isEmpty() || !src.getAlarms().isEmpty()) {
                        oscope.eventHandler = new OEventHandler(BpelCompiler.this._oprocess);
                        oscope.eventHandler.debugInfo = BpelCompiler.this.createDebugInfo(src, "Event Handler for " + src);
                    }
                    for (OnEvent onEvent : src.getEvents()) {
                        try {
                            BpelCompiler.this.compile(onEvent);
                        }
                        catch (CompilationException ce) {
                            BpelCompiler.this.recoveredFromError(src, ce);
                        }
                    }
                    for (OnAlarm onAlarm : src.getAlarms()) {
                        try {
                            BpelCompiler.this.compile(onAlarm);
                        }
                        catch (CompilationException ce) {
                            BpelCompiler.this.recoveredFromError(src, ce);
                        }
                    }
                    if (init != null) {
                        try {
                            init.run();
                        }
                        catch (CompilationException ce) {
                            BpelCompiler.this.recoveredFromError(src, ce);
                        }
                    }
                    try {
                        BpelCompiler.this.compile(src.getCompensationHandler());
                    }
                    catch (CompilationException bce) {
                        BpelCompiler.this.recoveredFromError(src.getCompensationHandler(), bce);
                    }
                    try {
                        BpelCompiler.this.compile(src.getTerminationHandler());
                    }
                    catch (CompilationException bce) {
                        BpelCompiler.this.recoveredFromError(src.getTerminationHandler(), bce);
                    }
                    try {
                        BpelCompiler.this.compile(src.getFaultHandler());
                    }
                    catch (CompilationException bce) {
                        BpelCompiler.this.recoveredFromError(src.getFaultHandler(), bce);
                    }
                }
            });
        }
        finally {
            this._atomicScope = previousAtomicScope;
        }
        return oscope;
    }

    private void compile(OnAlarm onAlarm) {
        OScope oscope = this._structureStack.topScope();
        assert (oscope.eventHandler != null);
        OEventHandler.OAlarm oalarm = new OEventHandler.OAlarm(this._oprocess);
        oalarm.debugInfo = this.createDebugInfo(onAlarm, "OnAlarm Event Handler: " + onAlarm);
        if (onAlarm.getFor() != null && onAlarm.getUntil() == null) {
            oalarm.forExpr = this.compileExpr(onAlarm.getFor());
        } else if (onAlarm.getFor() == null && onAlarm.getUntil() != null) {
            oalarm.untilExpr = this.compileExpr(onAlarm.getUntil());
        } else {
            if (onAlarm.getFor() != null && onAlarm.getUntil() != null) {
                throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onAlarm));
            }
            if (onAlarm.getRepeatEvery() == null) {
                throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onAlarm));
            }
        }
        if (onAlarm.getRepeatEvery() != null) {
            oalarm.repeatExpr = this.compileExpr(onAlarm.getRepeatEvery());
        }
        if (onAlarm.getActivity() == null) {
            throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onAlarm));
        }
        oalarm.activity = this.compile(onAlarm.getActivity());
        for (OLink link : oalarm.incomingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(link.name).setSource(onAlarm));
            }
            catch (CompilationException ce) {
                this.recoveredFromError(onAlarm, ce);
            }
        }
        for (OLink link : oalarm.outgoingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(link.name).setSource(onAlarm));
            }
            catch (CompilationException ce) {
                this.recoveredFromError(onAlarm, ce);
            }
        }
        oscope.eventHandler.onAlarms.add(oalarm);
    }

    private void compile(final OnEvent onEvent) {
        OScope oscope = this._structureStack.topScope();
        assert (oscope.eventHandler != null);
        final OEventHandler.OEvent oevent = new OEventHandler.OEvent(this._oprocess, (OActivity)oscope);
        oevent.name = "__eventHandler:";
        oevent.debugInfo = this.createDebugInfo(onEvent, null);
        this.compile((OActivity)oevent, onEvent, new Runnable(){

            @Override
            public void run() {
                switch (BpelCompiler.this._processDef.getBpelVersion()) {
                    case BPEL11: {
                        oevent.variable = BpelCompiler.this.resolveMessageVariable(onEvent.getVariable());
                        break;
                    }
                    case BPEL20_DRAFT: 
                    case BPEL20: {
                        OMessageVarType varType;
                        if (onEvent.getMessageType() == null && onEvent.getElementType() == null) {
                            throw new CompilationException(__cmsgs.errVariableDeclMissingType(onEvent.getVariable()).setSource(onEvent));
                        }
                        if (onEvent.getMessageType() != null && onEvent.getElementType() != null) {
                            throw new CompilationException(__cmsgs.errVariableDeclInvalid(onEvent.getVariable()).setSource(onEvent));
                        }
                        if (onEvent.getMessageType() != null) {
                            varType = BpelCompiler.this.resolveMessageType(onEvent.getMessageType());
                        } else if (onEvent.getElement() != null) {
                            varType = BpelCompiler.this.resolveElementType(onEvent.getElementType());
                        } else {
                            throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(onEvent.getVariable()));
                        }
                        oevent.variable = new OScope.Variable(BpelCompiler.this._oprocess, (OVarType)varType);
                        oevent.variable.name = onEvent.getVariable();
                        oevent.variable.declaringScope = BpelCompiler.this._structureStack.topScope();
                        oevent.addLocalVariable(oevent.variable);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected BPEL VERSION constatnt: " + (Object)((Object)BpelCompiler.this._processDef.getBpelVersion())));
                    }
                }
                oevent.partnerLink = BpelCompiler.this.resolvePartnerLink(onEvent.getPartnerLink());
                oevent.operation = BpelCompiler.this.resolveMyRoleOperation(oevent.partnerLink, onEvent.getOperation());
                oevent.messageExchangeId = onEvent.getMessageExchangeId();
                oevent.route = onEvent.getRoute();
                if (onEvent.getPortType() != null && !onEvent.getPortType().equals(oevent.partnerLink.myRolePortType.getQName())) {
                    throw new CompilationException(__cmsgs.errPortTypeMismatch(onEvent.getPortType(), oevent.partnerLink.myRolePortType.getQName()));
                }
                HashSet<String> csetNames = new HashSet<String>();
                for (Correlation correlation : onEvent.getCorrelations()) {
                    if (csetNames.contains(correlation.getCorrelationSet())) {
                        throw new CompilationException(__cmsgs.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
                    }
                    OScope.CorrelationSet cset = BpelCompiler.this.resolveCorrelationSet(correlation.getCorrelationSet());
                    switch (correlation.getInitiate()) {
                        case UNSET: 
                        case NO: {
                            oevent.matchCorrelations.add(cset);
                            oevent.partnerLink.addCorrelationSetForOperation(oevent.operation, cset, false);
                            break;
                        }
                        case YES: {
                            oevent.initCorrelations.add(cset);
                            break;
                        }
                        case JOIN: {
                            cset.hasJoinUseCases = true;
                            oevent.joinCorrelations.add(cset);
                            oevent.partnerLink.addCorrelationSetForOperation(oevent.operation, cset, true);
                        }
                    }
                    for (OProcess.OProperty property : cset.properties) {
                        BpelCompiler.this.resolvePropertyAlias(oevent.variable, property.name);
                    }
                    csetNames.add(correlation.getCorrelationSet());
                }
                if (onEvent.getActivity() == null) {
                    throw new CompilationException(__cmsgs.errInvalidAlarm().setSource(onEvent));
                }
                oevent.activity = BpelCompiler.this.compile(onEvent.getActivity());
            }
        });
        for (OLink link : oevent.incomingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(link.name));
            }
            catch (CompilationException ce) {
                this.recoveredFromError(onEvent, ce);
            }
        }
        for (OLink link : oevent.outgoingLinks) {
            try {
                throw new CompilationException(__cmsgs.errLinkCrossesEventHandlerBoundary(link.name));
            }
            catch (CompilationException ce) {
                this.recoveredFromError(onEvent, ce);
            }
        }
        oscope.eventHandler.onMessages.add(oevent);
    }

    private DebugInfo createDebugInfo(BpelObject bpelObject, String description) {
        int lineNo = bpelObject == null ? -1 : bpelObject.getLineNo();
        String str = description == null && bpelObject != null ? bpelObject.toString() : null;
        Map<QName, Object> extElmt = bpelObject == null ? null : bpelObject.getExtensibilityElements();
        DebugInfo debugInfo = new DebugInfo(this._processDef.getSource(), lineNo, extElmt);
        debugInfo.description = str;
        return debugInfo;
    }

    private void compile(Variable src) {
        OElementVarType varType;
        OScope oscope = this._structureStack.topScope();
        if (src.getKind() == null) {
            throw new CompilationException(__cmsgs.errVariableDeclMissingType(src.getName()).setSource(src));
        }
        if (oscope.getLocalVariable(src.getName()) != null) {
            throw new CompilationException(__cmsgs.errDuplicateVariableDecl(src.getName()).setSource(src));
        }
        if (src.getTypeName() == null) {
            throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(src.getName()));
        }
        switch (src.getKind()) {
            case ELEMENT: {
                varType = this.resolveElementType(src.getTypeName());
                break;
            }
            case MESSAGE: {
                varType = this.resolveMessageType(src.getTypeName());
                break;
            }
            case SCHEMA: {
                varType = this.resolveXsdType(src.getTypeName());
                break;
            }
            default: {
                throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(src.getName()));
            }
        }
        OScope.Variable ovar = new OScope.Variable(this._oprocess, (OVarType)varType);
        AssignGenerator agen = new AssignGenerator();
        agen.setContext(this);
        ovar.name = src.getName();
        ovar.declaringScope = oscope;
        ovar.debugInfo = this.createDebugInfo(src, null);
        From varfromSpec = src.getFrom();
        ovar.from = varfromSpec != null ? agen.compileFrom(varfromSpec, varType) : null;
        ovar.extVar = this.compileExtVar(src);
        oscope.addLocalVariable(ovar);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Compiled variable " + ovar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(TerminationHandler terminationHandler) {
        OScope oscope = this._structureStack.topScope();
        oscope.terminationHandler = new OTerminationHandler(this._oprocess, (OActivity)oscope);
        oscope.terminationHandler.name = "__terminationHandler:" + oscope.name;
        oscope.terminationHandler.debugInfo = this.createDebugInfo(terminationHandler, null);
        if (terminationHandler == null) {
            oscope.terminationHandler.activity = this.createDefaultCompensateActivity(null, "Auto-generated 'compensate all' pseudo-activity for default termination handler on " + oscope.toString());
        } else {
            this._recoveryContextStack.push(oscope);
            try {
                oscope.terminationHandler.activity = this.compile(terminationHandler.getActivity());
            }
            finally {
                this._recoveryContextStack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(CompensationHandler compensationHandler) {
        OScope oscope = this._structureStack.topScope();
        oscope.compensationHandler = new OCompensationHandler(this._oprocess, (OActivity)oscope);
        oscope.compensationHandler.name = "__compenationHandler_" + oscope.name;
        oscope.compensationHandler.debugInfo = this.createDebugInfo(compensationHandler, null);
        if (compensationHandler == null) {
            oscope.compensationHandler.activity = this.createDefaultCompensateActivity(compensationHandler, "Auto-generated 'compensate all' pseudo-activity for default compensation handler on  " + oscope.toString());
        } else {
            this._recoveryContextStack.push(oscope);
            try {
                oscope.compensationHandler.activity = this.compile(compensationHandler.getActivity());
            }
            finally {
                this._recoveryContextStack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(FaultHandler fh) {
        OScope oscope = this._structureStack.topScope();
        oscope.faultHandler = new OFaultHandler(this._oprocess);
        if (fh == null) {
            OCatch defaultCatch = new OCatch(this._oprocess, (OActivity)oscope);
            defaultCatch.name = "__defaultFaultHandler:" + oscope.name;
            defaultCatch.faultName = null;
            defaultCatch.faultVariable = null;
            OSequence sequence = new OSequence(this._oprocess, (OActivity)defaultCatch);
            sequence.name = "__defaultFaultHandler_sequence:" + oscope.name;
            sequence.debugInfo = this.createDebugInfo(fh, "Auto-generated sequence activity.");
            ORethrow rethrow = new ORethrow(this._oprocess, (OActivity)sequence);
            rethrow.name = "__defaultFaultHandler_rethrow:" + oscope.name;
            rethrow.debugInfo = this.createDebugInfo(fh, "Auto-generated re-throw activity.");
            sequence.sequence.add(this.createDefaultCompensateActivity(fh, "Default compensation handler for " + oscope));
            sequence.sequence.add(rethrow);
            defaultCatch.activity = sequence;
            oscope.faultHandler.catchBlocks.add(defaultCatch);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Compiled default catch block " + defaultCatch + " for " + oscope));
            }
        } else {
            this._recoveryContextStack.push(oscope);
            try {
                int i = 0;
                for (final Catch catchSrc : fh.getCatches()) {
                    final OCatch ctch = new OCatch(this._oprocess, (OActivity)oscope);
                    ctch.debugInfo = this.createDebugInfo(catchSrc, catchSrc.toString());
                    ctch.name = "__catch#" + i + ":" + this._structureStack.topScope().name;
                    ctch.faultName = catchSrc.getFaultName();
                    this.compile((OActivity)ctch, catchSrc, new Runnable(){

                        @Override
                        public void run() {
                            if (catchSrc.getFaultVariable() != null) {
                                OScope.Variable faultVar;
                                switch (BpelCompiler.this._processDef.getBpelVersion()) {
                                    case BPEL11: {
                                        faultVar = BpelCompiler.this.resolveVariable(catchSrc.getFaultVariable());
                                        if (faultVar.type instanceof OMessageVarType) break;
                                        throw new CompilationException(__cmsgs.errMessageVariableRequired(catchSrc.getFaultVariable()).setSource(catchSrc));
                                    }
                                    case BPEL20_DRAFT: 
                                    case BPEL20: {
                                        OMessageVarType faultVarType;
                                        if (catchSrc.getFaultVariableMessageType() == null && catchSrc.getFaultVariableElementType() == null) {
                                            throw new CompilationException(__cmsgs.errVariableDeclMissingType(catchSrc.getFaultVariable()).setSource(catchSrc));
                                        }
                                        if (catchSrc.getFaultVariableMessageType() != null && catchSrc.getFaultVariableElementType() != null) {
                                            throw new CompilationException(__cmsgs.errVariableDeclMissingType(catchSrc.getFaultVariable()).setSource(catchSrc));
                                        }
                                        if (catchSrc.getFaultVariableMessageType() != null) {
                                            faultVarType = BpelCompiler.this.resolveMessageType(catchSrc.getFaultVariableMessageType());
                                        } else if (catchSrc.getFaultVariableElementType() != null) {
                                            faultVarType = BpelCompiler.this.resolveElementType(catchSrc.getFaultVariableElementType());
                                        } else {
                                            throw new CompilationException(__cmsgs.errUnrecognizedVariableDeclaration(catchSrc.getFaultVariable()));
                                        }
                                        faultVar = new OScope.Variable(BpelCompiler.this._oprocess, (OVarType)faultVarType);
                                        faultVar.name = catchSrc.getFaultVariable();
                                        faultVar.declaringScope = BpelCompiler.this._structureStack.topScope();
                                        ctch.addLocalVariable(faultVar);
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError((Object)("Unexpected BPEL VERSION constatnt: " + (Object)((Object)BpelCompiler.this._processDef.getBpelVersion())));
                                    }
                                }
                                ctch.faultVariable = faultVar;
                            }
                            if (catchSrc.getActivity() == null) {
                                throw new CompilationException(__cmsgs.errEmptyCatch().setSource(catchSrc));
                            }
                            ((BpelCompiler)BpelCompiler.this)._structureStack.topScope().activity = BpelCompiler.this.compile(catchSrc.getActivity());
                        }
                    });
                    oscope.faultHandler.catchBlocks.add(ctch);
                    ++i;
                }
            }
            finally {
                this._recoveryContextStack.pop();
            }
        }
    }

    @Override
    public OXslSheet compileXslt(String docStrUri) throws CompilationException {
        URI docUri;
        try {
            docUri = new URI(FileUtils.encodePath((String)docStrUri));
        }
        catch (URISyntaxException e) {
            throw new CompilationException(__cmsgs.errInvalidDocXsltUri(docStrUri));
        }
        String sheetBody = this.loadXsltSheet(this._processURI.resolve(docUri));
        if (sheetBody == null) {
            throw new CompilationException(__cmsgs.errCantFindXslt(docStrUri));
        }
        OXslSheet oXslSheet = new OXslSheet(this._oprocess);
        oXslSheet.uri = docUri;
        oXslSheet.sheetBody = sheetBody;
        this._oprocess.xslSheets.put(oXslSheet.uri, oXslSheet);
        return oXslSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadXsltSheet(URI uri) {
        InputStream is;
        try {
            is = this._resourceFinder.openResource(uri);
        }
        catch (Exception e1) {
            return null;
        }
        if (is == null) {
            return null;
        }
        try {
            Document doc = DOMUtils.parse((InputStream)is);
            String string = DOMUtils.domToString((Node)doc);
            return string;
        }
        catch (Exception e) {
            __log.debug((Object)"IO error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public boolean isPartnerLinkAssigned(String plink) {
        for (OActivity act : this._compiledActivities) {
            if (!(act instanceof OAssign)) continue;
            OAssign assign = (OAssign)act;
            for (OAssign.Copy copy : assign.copy) {
                if (!(copy.to instanceof OAssign.PartnerLinkRef) || !((OAssign.PartnerLinkRef)copy.to).partnerLink.getName().equals(plink)) continue;
                return true;
            }
        }
        return false;
    }

    public Definition[] getWsdlDefinitions() {
        Definition[] result = new Definition[this._wsdlRegistry.getDefinitions().length];
        for (int m = 0; m < this._wsdlRegistry.getDefinitions().length; ++m) {
            Definition4BPEL definition4BPEL = this._wsdlRegistry.getDefinitions()[m];
            result[m] = definition4BPEL.getDefinition();
        }
        return result;
    }

    private OElementVarType resolveElementType(QName faultVariableElementType) {
        OElementVarType type = (OElementVarType)this._oprocess.elementTypes.get(faultVariableElementType);
        if (type == null) {
            type = new OElementVarType(this._oprocess, faultVariableElementType);
            this._oprocess.elementTypes.put(faultVariableElementType, type);
        }
        return type;
    }

    private ActivityGenerator findActivityGen(Activity source) {
        Class<?> actClass = source.getClass();
        for (Map.Entry<Class, ActivityGenerator> me : this._actGenerators.entrySet()) {
            Class cls = me.getKey();
            if (!cls.isAssignableFrom(actClass)) continue;
            ActivityGenerator gen = me.getValue();
            gen.setContext(this);
            return gen;
        }
        throw new CompilationException(__cmsgs.errUnknownActivity(actClass.getName()).setSource(source));
    }

    protected void registerActivityCompiler(Class defClass, ActivityGenerator generator) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Adding compiler for nodes class \"" + defClass.getName() + " = " + generator));
        }
        this._actGenerators.put(defClass, generator);
    }

    private ExpressionCompiler findExpLangCompiler(String expLang) {
        ExpressionCompiler compiler = this._expLanguageCompilers.get(expLang);
        if (compiler == null) {
            throw new CompilationException(__cmsgs.errUnknownExpressionLanguage(expLang));
        }
        return compiler;
    }

    private String getExpressionLanguage(Expression exp) {
        String expLang = exp.getExpressionLanguage();
        if (expLang == null) {
            expLang = this._processDef.getExpressionLanguage();
        }
        if (expLang == null) {
            expLang = this.getDefaultExpressionLanguage();
        }
        return expLang;
    }

    protected abstract String getDefaultExpressionLanguage();

    protected abstract String getBpwsNamespace();

    protected void registerExpressionLanguage(String expLangUri, ExpressionCompiler expressionCompiler) {
        this._expLanguageCompilers.put(expLangUri, expressionCompiler);
    }

    protected void registerExpressionLanguage(String expLangUri, String classname) throws Exception {
        Class<?> cls = Class.forName(classname);
        this.registerExpressionLanguage(expLangUri, (ExpressionCompiler)cls.newInstance());
    }

    @Override
    public List<OActivity> getActivityStack() {
        ArrayList<OActivity> rval = new ArrayList<OActivity>(this._structureStack._stack);
        Collections.reverse(rval);
        return rval;
    }

    @Override
    public Map<URI, Source> getSchemaSources() {
        return this._wsdlRegistry.getSchemaSources();
    }

    @Override
    public URI getBaseResourceURI() {
        return this._resourceFinder.getBaseResourceURI();
    }

    private OExtVar compileExtVar(Variable src) {
        if (!src.isExternal()) {
            return null;
        }
        OExtVar oextvar = new OExtVar(this._oprocess);
        oextvar.externalVariableId = src.getExternalId();
        oextvar.debugInfo = this.createDebugInfo(src, null);
        if (src.getExternalId() == null) {
            throw new CompilationException(__cmsgs.errMustSpecifyExternalVariableId(src.getName()));
        }
        if (src.getRelated() == null) {
            throw new CompilationException(__cmsgs.errMustSpecifyRelatedVariable(src.getName()));
        }
        oextvar.related = this.resolveVariable(src.getRelated());
        return oextvar;
    }

    private static class StructureStack {
        private Stack<OActivity> _stack = new Stack();
        private Map<OActivity, BpelObject> _srcMap = new HashMap<OActivity, BpelObject>();

        private StructureStack() {
        }

        public void push(OActivity act, BpelObject src) {
            this._stack.push(act);
            this._srcMap.put(act, src);
        }

        public BpelObject topSource() {
            return this._srcMap.get(this.topActivity());
        }

        public OScope topScope() {
            List<OScope> scopeStack = this.scopeStack();
            return scopeStack.isEmpty() ? null : scopeStack.get(scopeStack.size() - 1);
        }

        public OScope rootScope() {
            for (OActivity oActivity : this._stack) {
                if (!(oActivity instanceof OScope)) continue;
                return (OScope)oActivity;
            }
            return null;
        }

        public OActivity pop() {
            return this._stack.pop();
        }

        public void clear() {
            this._stack.clear();
        }

        public int size() {
            return this._stack.size();
        }

        public Iterator<OScope> oscopeIterator() {
            List<OScope> scopeStack = this.scopeStack();
            Collections.reverse(scopeStack);
            return scopeStack.iterator();
        }

        private List<OScope> scopeStack() {
            ArrayList<OScope> newList = new ArrayList<OScope>();
            CollectionsX.filter(newList, this._stack.iterator(), OScope.class);
            return newList;
        }

        public OActivity topActivity() {
            return this._stack.isEmpty() ? null : this._stack.peek();
        }

        public Iterator<OActivity> iterator() {
            ArrayList<OActivity> rval = new ArrayList<OActivity>(this._stack);
            Collections.reverse(rval);
            return rval.iterator();
        }
    }
}

