/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceMetadata;
import org.switchyard.event.ServiceUnregistrationEvent;
import org.switchyard.internal.DomainImpl;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceMetadataBuilder;

public class ServiceImpl
implements Service {
    private QName _name;
    private ServiceInterface _interface;
    private DomainImpl _domain;
    private ExchangeHandler _providerHandler;
    private ServiceMetadata _metadata;

    public ServiceImpl(QName name, ServiceInterface serviceInterface, DomainImpl domain, ExchangeHandler providerHandler) {
        this(name, serviceInterface, domain, providerHandler, null);
    }

    public ServiceImpl(QName name, ServiceInterface serviceInterface, DomainImpl domain, ExchangeHandler providerHandler, ServiceMetadata metadata) {
        this._name = name;
        this._interface = serviceInterface;
        this._domain = domain;
        this._providerHandler = providerHandler;
        this._metadata = metadata != null ? metadata : ServiceMetadataBuilder.create().build();
    }

    public ServiceInterface getInterface() {
        return this._interface;
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }

    public void unregister() {
        this._domain.getServiceRegistry().unregisterService(this);
        this._domain.getEventPublisher().publish((EventObject)new ServiceUnregistrationEvent((Service)this));
    }

    public ExchangeHandler getProviderHandler() {
        return this._providerHandler;
    }

    public String toString() {
        return "Service [name=" + this._name + ", interface=" + this._interface + ", domain=" + this._domain + ", metadata=" + this._metadata + "]";
    }

    public ServiceMetadata getServiceMetadata() {
        return this._metadata;
    }
}

