/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy;

import org.switchyard.BaseHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.deploy.BaseDeployMessages;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.deploy.ServiceHandler;

public class BaseServiceHandler
extends BaseHandler
implements ServiceHandler {
    private Lifecycle.State _state = Lifecycle.State.NONE;
    private final ServiceDomain _domain;

    public BaseServiceHandler() {
        this(null);
    }

    protected BaseServiceHandler(ServiceDomain domain) {
        this._domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        if (this._state == Lifecycle.State.STARTED) {
            return;
        }
        if (this._state != Lifecycle.State.NONE) {
            throw BaseDeployMessages.MESSAGES.invalidHandlerState();
        }
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader deploymentCL = this.getDeploymentClassLoader();
            if (deploymentCL != null) {
                Thread.currentThread().setContextClassLoader(deploymentCL);
            }
            this.setState(Lifecycle.State.STARTING);
            try {
                this.doStart();
                this.setState(Lifecycle.State.STARTED);
            }
            catch (RuntimeException e) {
                this.setState(Lifecycle.State.NONE);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this._state == Lifecycle.State.NONE) {
            return;
        }
        if (this._state != Lifecycle.State.STARTED) {
            throw BaseDeployMessages.MESSAGES.invalidHandlerState();
        }
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader deploymentCL = this.getDeploymentClassLoader();
            if (deploymentCL != null) {
                Thread.currentThread().setContextClassLoader(deploymentCL);
            }
            this.setState(Lifecycle.State.STOPPING);
            try {
                this.doStop();
                this.setState(Lifecycle.State.NONE);
            }
            catch (RuntimeException e) {
                this.setState(Lifecycle.State.STARTED);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    protected void doStop() {
    }

    @Override
    public Lifecycle.State getState() {
        return this._state;
    }

    protected void setState(Lifecycle.State newState) {
        if (newState == null) {
            throw BaseDeployMessages.MESSAGES.stateCannotBeNull();
        }
        this._state = newState;
    }

    protected ClassLoader getDeploymentClassLoader() {
        return this._domain == null ? null : (ClassLoader)this._domain.getProperty("org.switchyard.deployment.DeploymentClassLoader");
    }
}

