/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.VersionLogger;
import ca.uhn.hl7v2.model.AbstractStructure;
import ca.uhn.hl7v2.model.GenericGroup;
import ca.uhn.hl7v2.model.GenericSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroup
extends AbstractStructure
implements Group {
    private static final int PS_INDENT = 3;
    private static final long serialVersionUID = 1772720246448224363L;
    private List<String> names;
    private Map<String, List<Structure>> structures;
    private Map<String, Boolean> required;
    private Map<String, Boolean> repeating;
    private Set<String> choiceElements;
    private Map<String, Class<? extends Structure>> classes;
    private Set<String> nonStandardNames;
    private final ModelClassFactory myFactory;

    protected AbstractGroup(Group parent, ModelClassFactory factory) {
        super(parent);
        this.myFactory = factory;
        this.init();
    }

    private void init() {
        this.names = new ArrayList<String>();
        this.structures = new HashMap<String, List<Structure>>();
        this.required = new HashMap<String, Boolean>();
        this.repeating = new HashMap<String, Boolean>();
        this.classes = new HashMap<String, Class<? extends Structure>>();
        this.choiceElements = new HashSet<String>();
    }

    @Override
    public Structure get(String name) throws HL7Exception {
        return this.get(name, 0);
    }

    protected <T extends Structure> T getTyped(String name, Class<T> type) {
        try {
            Structure ret = this.get(name);
            return (T)ret;
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Structure get(String name, int rep) throws HL7Exception {
        Structure ret;
        List<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception(name + " does not exist in the group " + this.getClass().getName());
        }
        if (rep < list.size()) {
            ret = list.get(rep);
        } else if (rep == list.size()) {
            Boolean repeats = this.repeating.get(name);
            if (!repeats.booleanValue() && list.size() > 0) {
                throw new HL7Exception("Can't create repetition #" + rep + " of Structure " + name + " - this Structure is non-repeating so only rep 0 may be retrieved");
            }
            Class<? extends Structure> c = this.classes.get(name);
            ret = this.tryToInstantiateStructure(c, name);
            list.add(ret);
        } else {
            StringBuilder b = new StringBuilder();
            b.append("Can't return repetition #");
            b.append(rep);
            b.append(" of ");
            b.append(name);
            b.append(" - there are currently ");
            if (list.size() == 0) {
                b.append("no");
            } else {
                b.append("only ");
                b.append(list.size());
            }
            b.append(" repetitions ");
            b.append("so rep# must be ");
            if (list.size() == 0) {
                b.append("0");
            } else {
                b.append("between 0 and ");
                b.append(list.size());
            }
            throw new HL7Exception(b.toString());
        }
        return ret;
    }

    @Override
    public boolean isEmpty() throws HL7Exception {
        for (String name : this.getNames()) {
            if (this.get(name).isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected <T extends Structure> T getTyped(String name, int rep, Class<T> type) {
        try {
            Structure ret = this.get(name, rep);
            return (T)ret;
        }
        catch (HL7Exception e) {
            List<Structure> list = this.structures.get(name);
            if (list == null || list.size() >= rep) {
                this.log.error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    protected int getReps(String name) {
        try {
            return this.getAll(name).length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            this.log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    @Override
    public String addNonstandardSegment(String name) throws HL7Exception {
        String version = this.getMessage().getVersion();
        if (version == null) {
            throw new HL7Exception("Need message version to add segment by name; message.getVersion() returns null");
        }
        Class<? extends Segment> c = this.myFactory.getSegmentClass(name, version);
        if (c == null) {
            c = GenericSegment.class;
        }
        int index = this.getNames().length;
        this.tryToInstantiateStructure(c, name);
        String newName = this.insert(c, false, true, index, name);
        if (this.nonStandardNames == null) {
            this.nonStandardNames = new HashSet<String>();
        }
        this.nonStandardNames.add(newName);
        return newName;
    }

    @Override
    public String addNonstandardSegment(String theName, int theIndex) throws HL7Exception {
        if (this instanceof Message && theIndex == 0) {
            throw new HL7Exception("Can not add nonstandard segment \"" + theName + "\" to start of message.");
        }
        String version = this.getMessage().getVersion();
        if (version == null) {
            throw new HL7Exception("Need message version to add segment by name; message.getVersion() returns null");
        }
        Class<? extends Segment> c = this.myFactory.getSegmentClass(theName, version);
        if (c == null) {
            c = GenericSegment.class;
        }
        this.tryToInstantiateStructure(c, theName);
        String newName = this.insert(c, false, true, theIndex, theName);
        if (this.nonStandardNames == null) {
            this.nonStandardNames = new HashSet<String>();
        }
        this.nonStandardNames.add(newName);
        return newName;
    }

    public Set<String> getNonStandardNames() {
        if (this.nonStandardNames == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.nonStandardNames);
    }

    @Override
    public String[] getNames() {
        String[] retVal = new String[this.names.size()];
        for (int i = 0; i < this.names.size(); ++i) {
            retVal[i] = this.names.get(i);
        }
        return retVal;
    }

    protected String add(Class<? extends Structure> c, boolean required, boolean repeating) throws HL7Exception {
        return this.add(c, required, repeating, false);
    }

    protected String add(Class<? extends Structure> c, boolean required, boolean repeating, boolean choiceElement) throws HL7Exception {
        String name = this.getName(c);
        return this.insert(c, required, repeating, choiceElement, this.names.size(), name);
    }

    protected String add(Class<? extends Structure> c, boolean required, boolean repeating, int index) throws HL7Exception {
        String name = this.getName(c);
        return this.insert(c, required, repeating, index, name);
    }

    private boolean nameExists(String name) {
        return this.classes.get(name) != null;
    }

    protected Structure tryToInstantiateStructure(Class<? extends Structure> c, String name) throws HL7Exception {
        if (GenericSegment.class.isAssignableFrom(c)) {
            String genericName = name;
            if (genericName.length() > 3) {
                genericName = genericName.substring(0, 3);
            }
            return new GenericSegment((Group)this, genericName);
        }
        if (GenericGroup.class.isAssignableFrom(c)) {
            return new GenericGroup(this, name, this.myFactory);
        }
        try {
            return ReflectionUtil.instantiateStructure(c, this, this.myFactory);
        }
        catch (Exception e) {
            return ReflectionUtil.instantiate(c);
        }
    }

    @Override
    public boolean isChoiceElement(String theName) throws HL7Exception {
        return this.choiceElements.contains(theName);
    }

    @Override
    public boolean isGroup(String name) throws HL7Exception {
        Class<? extends Structure> clazz = this.classes.get(name);
        if (clazz == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        return Group.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isRequired(String name) throws HL7Exception {
        Boolean req = this.required.get(name);
        if (req == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        return req;
    }

    @Override
    public boolean isRepeating(String name) throws HL7Exception {
        Boolean rep = this.repeating.get(name);
        if (rep == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        return rep;
    }

    public int currentReps(String name) throws HL7Exception {
        List<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        return list.size();
    }

    @Override
    public Structure[] getAll(String name) throws HL7Exception {
        List<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        return list.toArray(new Structure[list.size()]);
    }

    protected <T extends Structure> List<T> getAllAsList(String name, Class<T> theType) throws HL7Exception {
        Class<? extends Structure> clazz = this.classes.get(name);
        if (!theType.equals(clazz)) {
            throw new HL7Exception("Structure with name \"" + name + "\" has type " + clazz.getName() + " but should be " + theType);
        }
        ArrayList<Structure> retVal = new ArrayList<Structure>();
        for (Structure next : this.structures.get(name)) {
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public Structure removeRepetition(String name, int index) throws HL7Exception {
        List<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        if (list.size() == 0) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " has no repetitions");
        }
        if (list.size() <= index) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " must be between 0 and " + (list.size() - 1));
        }
        return list.remove(index);
    }

    protected void insertRepetition(String name, Structure structure, int index) throws HL7Exception {
        if (structure == null) {
            throw new NullPointerException("Structure may not be null");
        }
        if (structure.getMessage() != this.getMessage()) {
            throw new HL7Exception("Structure does not belong to this message");
        }
        List<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName());
        }
        if (list.size() < index) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " must be between 0 and " + list.size());
        }
        list.add(index, structure);
    }

    public Structure insertRepetition(String name, int index) throws HL7Exception {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Name may not be null/empty");
        }
        Class<? extends Structure> structureClass = this.classes.get(name);
        if (structureClass == null) {
            throw new HL7Exception("Group " + this.getClass().getName() + " has no structure named " + name + ": Valid names: " + this.classes.keySet());
        }
        Structure rep = this.tryToInstantiateStructure(structureClass, name);
        this.insertRepetition(name, rep, index);
        return rep;
    }

    public int getFieldNumForName(String name) throws HL7Exception {
        int retVal = this.names.indexOf(name);
        if (retVal == -1) {
            throw new HL7Exception("Unknown name: " + name);
        }
        return retVal + 1;
    }

    @Override
    public Class<? extends Structure> getClass(String name) {
        return this.classes.get(name);
    }

    @Override
    public String getName() {
        return this.getName(this.getClass());
    }

    private String getName(Class<? extends Structure> c) {
        String name = c.getSimpleName();
        if (Group.class.isAssignableFrom(c) && !Message.class.isAssignableFrom(c)) {
            name = this.getGroupName(name);
        }
        return name;
    }

    private String getGroupName(String name) {
        Class<?> messageClass = this.getMessage().getClass();
        while (Message.class.isAssignableFrom(messageClass)) {
            String messageName = this.getName(messageClass);
            if (name.startsWith(messageName) && name.length() > messageName.length()) {
                return name.substring(messageName.length() + 1);
            }
            messageClass = messageClass.getSuperclass();
        }
        return name;
    }

    protected String insert(Class<? extends Structure> c, boolean required, boolean repeating, int index, String name) throws HL7Exception {
        return this.insert(c, required, repeating, false, index, name);
    }

    protected String insert(Class<? extends Structure> c, boolean required, boolean repeating, boolean choiceElement, int index, String name) throws HL7Exception {
        if (this.nameExists(name)) {
            int version = 2;
            String newName = name;
            while (this.nameExists(newName)) {
                newName = name + version++;
            }
            name = newName;
        }
        if (index > this.names.size()) {
            throw new HL7Exception("Invalid index " + index + " - Should be <= " + this.names.size());
        }
        this.names.add(index, name);
        this.required.put(name, new Boolean(required));
        this.repeating.put(name, new Boolean(repeating));
        this.classes.put(name, c);
        this.structures.put(name, new ArrayList());
        if (choiceElement) {
            this.choiceElements.add(name);
        }
        return name;
    }

    public void clear() {
        for (List<Structure> next : this.structures.values()) {
            if (next == null) continue;
            next.clear();
        }
    }

    public final ModelClassFactory getModelClassFactory() {
        return this.myFactory;
    }

    void appendStructureDescription(StringBuilder theStringBuilder, int theIndent, boolean theOptional, boolean theRepeating, boolean theAddStartName, boolean theAddEndName, boolean thePrintEmpty) throws HL7Exception {
        String lineSeparator = System.getProperty("line.separator");
        if (theAddStartName) {
            this.indent(theStringBuilder, theIndent);
            theStringBuilder.append(this.getName()).append(" (start)").append(lineSeparator);
        }
        if (theOptional || theRepeating) {
            this.indent(theStringBuilder, theIndent);
            if (theOptional) {
                theStringBuilder.append("[");
            }
            if (theRepeating) {
                theStringBuilder.append("{");
            }
            theStringBuilder.append(lineSeparator);
        }
        boolean inChoice = false;
        for (String nextName : this.getNames()) {
            if (!thePrintEmpty) {
                Structure[] allReps;
                boolean hasContent = false;
                for (Structure structure : allReps = this.getAll(nextName)) {
                    if (structure.isEmpty()) continue;
                    hasContent = true;
                    break;
                }
                if (!hasContent) continue;
            }
            Class<? extends Structure> nextClass = this.classes.get(nextName);
            boolean nextOptional = !this.isRequired(nextName);
            boolean nextRepeating = this.isRepeating(nextName);
            boolean nextChoice = this.isChoiceElement(nextName);
            if (nextChoice && !inChoice) {
                this.indent(theStringBuilder, theIndent += 3);
                theStringBuilder.append("<");
                theStringBuilder.append(lineSeparator);
                inChoice = true;
            } else if (!nextChoice && inChoice) {
                this.indent(theStringBuilder, theIndent);
                theStringBuilder.append(">");
                theStringBuilder.append(lineSeparator);
                inChoice = false;
                theIndent -= 3;
            } else if (nextChoice && inChoice) {
                this.indent(theStringBuilder, theIndent);
                theStringBuilder.append("|");
                theStringBuilder.append(lineSeparator);
            }
            if (AbstractGroup.class.isAssignableFrom(nextClass)) {
                Structure[] nextChildren = this.getAll(nextName);
                for (int i = 0; i < nextChildren.length; ++i) {
                    Structure structure = nextChildren[i];
                    boolean addStartName = i == 0;
                    boolean addEndName = i == nextChildren.length - 1;
                    ((AbstractGroup)structure).appendStructureDescription(theStringBuilder, theIndent + 3, nextOptional, nextRepeating, addStartName, addEndName, thePrintEmpty);
                }
                if (nextChildren.length != 0) continue;
                Structure structure = this.tryToInstantiateStructure(nextClass, nextName);
                ((AbstractGroup)structure).appendStructureDescription(theStringBuilder, theIndent + 3, nextOptional, nextRepeating, true, true, thePrintEmpty);
                continue;
            }
            if (!Segment.class.isAssignableFrom(nextClass)) continue;
            int currentIndent = theStringBuilder.length();
            StringBuilder structurePrefix = new StringBuilder();
            this.indent(structurePrefix, theIndent + 3);
            if (nextOptional) {
                structurePrefix.append("[ ");
            }
            if (nextRepeating) {
                structurePrefix.append("{ ");
            }
            structurePrefix.append(nextName);
            if (nextRepeating) {
                structurePrefix.append(" }");
            }
            if (nextOptional) {
                structurePrefix.append(" ]");
            }
            if (this.nonStandardNames != null && this.nonStandardNames.contains(nextName)) {
                structurePrefix.append(" (non-standard)");
            }
            structurePrefix.append(" - ");
            currentIndent = theStringBuilder.length() - currentIndent;
            List<Structure> nextStructureList = this.structures.get(nextName);
            theStringBuilder.append((CharSequence)structurePrefix);
            if (nextStructureList == null || nextStructureList.isEmpty()) {
                theStringBuilder.append("Not populated");
                theStringBuilder.append(lineSeparator);
                continue;
            }
            for (int i = 0; i < nextStructureList.size(); ++i) {
                if (i > 0) {
                    this.indent(theStringBuilder, currentIndent + structurePrefix.length());
                }
                Segment nextSegment = (Segment)nextStructureList.get(i);
                theStringBuilder.append(new PipeParser().doEncode(nextSegment, EncodingCharacters.getInstance(this.getMessage())));
                theStringBuilder.append(lineSeparator);
            }
        }
        if (inChoice) {
            this.indent(theStringBuilder, theIndent);
            theStringBuilder.append(">");
            theStringBuilder.append(lineSeparator);
            theIndent -= 3;
        }
        if (theOptional || theRepeating) {
            this.indent(theStringBuilder, theIndent);
            if (theRepeating) {
                theStringBuilder.append("}");
            }
            if (theOptional) {
                theStringBuilder.append("]");
            }
            theStringBuilder.append(lineSeparator);
        }
        if (theAddEndName) {
            this.indent(theStringBuilder, theIndent);
            theStringBuilder.append(this.getName()).append(" (end)").append(lineSeparator);
        }
    }

    private void indent(StringBuilder theStringBuilder, int theIndent) {
        for (int i = 0; i < theIndent; ++i) {
            theStringBuilder.append(' ');
        }
    }

    static {
        VersionLogger.init();
    }
}

