/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v21.datatype.CE;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OBX
extends AbstractSegment {
    public OBX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - OBSERVATION SIMPLE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(125)}, "VALUE TYPE");
            this.add(CE.class, true, 1, 80, new Object[]{this.getMessage()}, "OBSERVATION IDENTIFIER");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "OBSERVATION SUB-ID");
            this.add(Varies.class, true, 1, 65, new Object[]{this.getMessage()}, "OBSERVATION RESULTS");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "UNITS");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "REFERENCES RANGE");
            this.add(ST.class, false, 5, 10, new Object[]{this.getMessage()}, "ABNORMAL FLAGS");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "PROBABILITY");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(80)}, "NATURE OF ABNORMAL TEST");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(85)}, "OBSERV RESULT STATUS");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "DATE LAST OBS NORMAL VALUES");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OBX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDOBSERVATIONSIMPLE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getObx1_SETIDOBSERVATIONSIMPLE() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getVALUETYPE() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getObx2_VALUETYPE() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOBSERVATIONIDENTIFIER() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getObx3_OBSERVATIONIDENTIFIER() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getOBSERVATIONSUBID() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getObx4_OBSERVATIONSUBID() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public Varies getOBSERVATIONRESULTS() {
        Varies retVal = (Varies)this.getTypedField(5, 0);
        return retVal;
    }

    public Varies getObx5_OBSERVATIONRESULTS() {
        Varies retVal = (Varies)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getUNITS() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getObx6_UNITS() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getREFERENCESRANGE() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getObx7_REFERENCESRANGE() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST[] getABNORMALFLAGS() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public ST[] getObx8_ABNORMALFLAGS() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public int getABNORMALFLAGSReps() {
        return this.getReps(8);
    }

    public ST getABNORMALFLAGS(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public ST getObx8_ABNORMALFLAGS(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public int getObx8_ABNORMALFLAGSReps() {
        return this.getReps(8);
    }

    public ST insertABNORMALFLAGS(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST insertObx8_ABNORMALFLAGS(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST removeABNORMALFLAGS(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST removeObx8_ABNORMALFLAGS(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public NM getPROBABILITY() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getObx9_PROBABILITY() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getNATUREOFABNORMALTEST() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getObx10_NATUREOFABNORMALTEST() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getOBSERVRESULTSTATUS() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getObx11_OBSERVRESULTSTATUS() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public TS getDATELASTOBSNORMALVALUES() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    public TS getObx12_DATELASTOBSNORMALVALUES() {
        TS retVal = (TS)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new Varies(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(80));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(85));
            }
            case 11: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

