/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIP
extends AbstractSegment {
    public AIP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIP");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(XCN.class, false, 1, 80, new Object[]{this.getMessage()}, "Personnel Resource ID");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Resource Role");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Resource Group");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Duration");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Duration Units");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(279)}, "Allow Substitution Code");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating AIP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIP() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAip1_SetIDAIP() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAip2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XCN getPersonnelResourceID() {
        XCN retVal = (XCN)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN getAip3_PersonnelResourceID() {
        XCN retVal = (XCN)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getResourceRole() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAip4_ResourceRole() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE[] getResourceGroup() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public CE[] getAip5_ResourceGroup() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public int getResourceGroupReps() {
        return this.getReps(5);
    }

    public CE getResourceGroup(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public CE getAip5_ResourceGroup(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getAip5_ResourceGroupReps() {
        return this.getReps(5);
    }

    public CE insertResourceGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE insertAip5_ResourceGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE removeResourceGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE removeAip5_ResourceGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public TS getStartDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getAip6_StartDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getAip7_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getStartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getAip8_StartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAip9_Duration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getDurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getAip10_DurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getAllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getAip11_AllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getFillerStatusCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getAip12_FillerStatusCode() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(279));
            }
            case 11: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

