/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.IAM;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.PV1;
import ca.uhn.hl7v2.model.v24.segment.PV2;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A60
extends AbstractMessage {
    public ADT_A60() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A60(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PV1.class, false, false);
            this.add(PV2.class, false, false);
            this.add(IAM.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_A60 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }

    public IAM getIAM() {
        return this.getTyped("IAM", IAM.class);
    }

    public IAM getIAM(int rep) {
        return this.getTyped("IAM", rep, IAM.class);
    }

    public int getIAMReps() {
        return this.getReps("IAM");
    }

    public List<IAM> getIAMAll() throws HL7Exception {
        return this.getAllAsList("IAM", IAM.class);
    }

    public void insertIAM(IAM structure, int rep) throws HL7Exception {
        super.insertRepetition("IAM", structure, rep);
    }

    public IAM insertIAM(int rep) throws HL7Exception {
        return (IAM)super.insertRepetition("IAM", rep);
    }

    public IAM removeIAM(int rep) throws HL7Exception {
        return (IAM)super.removeRepetition("IAM", rep);
    }
}

