/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.RAS_O17_ORDER;
import ca.uhn.hl7v2.model.v24.group.RAS_O17_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O17
extends AbstractMessage {
    public RAS_O17() {
        this(new DefaultModelClassFactory());
    }

    public RAS_O17(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RAS_O17_PATIENT.class, false, false);
            this.add(RAS_O17_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAS_O17 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RAS_O17_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", RAS_O17_PATIENT.class);
    }

    public RAS_O17_ORDER getORDER() {
        return this.getTyped("ORDER", RAS_O17_ORDER.class);
    }

    public RAS_O17_ORDER getORDER(int rep) {
        return this.getTyped("ORDER", rep, RAS_O17_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RAS_O17_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RAS_O17_ORDER.class);
    }

    public void insertORDER(RAS_O17_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public RAS_O17_ORDER insertORDER(int rep) throws HL7Exception {
        return (RAS_O17_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RAS_O17_ORDER removeORDER(int rep) throws HL7Exception {
        return (RAS_O17_ORDER)super.removeRepetition("ORDER", rep);
    }
}

