/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ISD
extends AbstractSegment {
    public ISD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Reference Interaction Number (unique identifier)");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Interaction Type Identifier");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Interaction Active State");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ISD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getReferenceInteractionNumberUniqueidentifier() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getIsd1_ReferenceInteractionNumberUniqueidentifier() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getInteractionTypeIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getIsd2_InteractionTypeIdentifier() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getInteractionActiveState() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getIsd3_InteractionActiveState() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

