/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.ORL_O22_SPECIMEN;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O22_OBSERVATION_REQUEST
extends AbstractGroup {
    public ORL_O22_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(ORL_O22_SPECIMEN.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORL_O22_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public ORL_O22_SPECIMEN getSPECIMEN() {
        ORL_O22_SPECIMEN retVal = this.getTyped("SPECIMEN", ORL_O22_SPECIMEN.class);
        return retVal;
    }

    public ORL_O22_SPECIMEN getSPECIMEN(int rep) {
        ORL_O22_SPECIMEN retVal = this.getTyped("SPECIMEN", rep, ORL_O22_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<ORL_O22_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", ORL_O22_SPECIMEN.class);
    }

    public void insertSPECIMEN(ORL_O22_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public ORL_O22_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O22_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public ORL_O22_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (ORL_O22_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

