/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CP;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DG1
extends AbstractSegment {
    public DG1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - DG1");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(53)}, "Diagnosis Coding Method");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Diagnosis Code - DG1");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "Diagnosis Description");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Diagnosis Date/Time");
            this.add(IS.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(52)}, "Diagnosis Type");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Major Diagnostic Category");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Diagnostic Related Group");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "DRG Approval Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(56)}, "DRG Grouper Review Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Outlier Type");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Outlier Days");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Outlier Cost");
            this.add(ST.class, false, 1, 4, new Object[]{this.getMessage()}, "Grouper Version And Type");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(359)}, "Diagnosis Priority");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Diagnosing Clinician");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(228)}, "Diagnosis Classification");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Confidential Indicator");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Attestation Date/Time");
            this.add(EI.class, false, 1, 427, new Object[]{this.getMessage()}, "Diagnosis Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(206)}, "Diagnosis Action Code");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating DG1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDDG1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getDg11_SetIDDG1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getDiagnosisCodingMethod() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getDg12_DiagnosisCodingMethod() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getDiagnosisCodeDG1() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getDg13_DiagnosisCodeDG1() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getDiagnosisDescription() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getDg14_DiagnosisDescription() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getDiagnosisDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDg15_DiagnosisDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getDiagnosisType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public IS getDg16_DiagnosisType() {
        IS retVal = (IS)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getMajorDiagnosticCategory() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getDg17_MajorDiagnosticCategory() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getDiagnosticRelatedGroup() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getDg18_DiagnosticRelatedGroup() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getDRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getDg19_DRGApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getDRGGrouperReviewCode() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getDg110_DRGGrouperReviewCode() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getOutlierType() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public CE getDg111_OutlierType() {
        CE retVal = (CE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getOutlierDays() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getDg112_OutlierDays() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getOutlierCost() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getDg113_OutlierCost() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getGrouperVersionAndType() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ST getDg114_GrouperVersionAndType() {
        ST retVal = (ST)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getDiagnosisPriority() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getDg115_DiagnosisPriority() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN[] getDiagnosingClinician() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public XCN[] getDg116_DiagnosingClinician() {
        XCN[] retVal = (XCN[])this.getTypedField(16, new XCN[0]);
        return retVal;
    }

    public int getDiagnosingClinicianReps() {
        return this.getReps(16);
    }

    public XCN getDiagnosingClinician(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public XCN getDg116_DiagnosingClinician(int rep) {
        XCN retVal = (XCN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getDg116_DiagnosingClinicianReps() {
        return this.getReps(16);
    }

    public XCN insertDiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN insertDg116_DiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(16, rep);
    }

    public XCN removeDiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public XCN removeDg116_DiagnosingClinician(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(16, rep);
    }

    public IS getDiagnosisClassification() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getDg117_DiagnosisClassification() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getDg118_ConfidentialIndicator() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getAttestationDateTime() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public TS getDg119_AttestationDateTime() {
        TS retVal = (TS)this.getTypedField(19, 0);
        return retVal;
    }

    public EI getDiagnosisIdentifier() {
        EI retVal = (EI)this.getTypedField(20, 0);
        return retVal;
    }

    public EI getDg120_DiagnosisIdentifier() {
        EI retVal = (EI)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getDiagnosisActionCode() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getDg121_DiagnosisActionCode() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(53));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(52));
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(56));
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(359));
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(228));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 18: {
                return new TS(this.getMessage());
            }
            case 19: {
                return new EI(this.getMessage());
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(206));
            }
        }
        return null;
    }
}

