/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.CX;
import ca.uhn.hl7v2.model.v251.datatype.DLN;
import ca.uhn.hl7v2.model.v251.datatype.HD;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.IS;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.SI;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.XAD;
import ca.uhn.hl7v2.model.v251.datatype.XPN;
import ca.uhn.hl7v2.model.v251.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PID
extends AbstractSegment {
    public PID(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - PID");
            this.add(CX.class, false, 1, 20, new Object[]{this.getMessage()}, "Patient ID");
            this.add(CX.class, true, 0, 250, new Object[]{this.getMessage()}, "Patient Identifier List");
            this.add(CX.class, false, 0, 20, new Object[]{this.getMessage()}, "Alternate Patient ID - PID");
            this.add(XPN.class, true, 0, 250, new Object[]{this.getMessage()}, "Patient Name");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Mother's Maiden Name");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of Birth");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Administrative Sex");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Patient Alias");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Race");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Patient Address");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(289)}, "County Code");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Phone Number - Home");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Phone Number - Business");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Primary Language");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Marital Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Religion");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Patient Account Number");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "SSN Number - Patient");
            this.add(DLN.class, false, 1, 25, new Object[]{this.getMessage()}, "Driver's License Number - Patient");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage()}, "Mother's Identifier");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Ethnic Group");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Birth Place");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Multiple Birth Indicator");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Birth Order");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Citizenship");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Veterans Military Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Nationality");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Patient Death Date and Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Patient Death Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Identity Unknown Indicator");
            this.add(IS.class, false, 0, 20, new Object[]{this.getMessage(), new Integer(445)}, "Identity Reliability Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Last Update Date/Time");
            this.add(HD.class, false, 1, 241, new Object[]{this.getMessage()}, "Last Update Facility");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Species Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Breed Code");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Strain");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Production Class Code");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Tribal Citizenship");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PID - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPid1_SetIDPID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX getPatientID() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getPid2_PatientID() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX[] getPatientIdentifierList() {
        CX[] retVal = (CX[])this.getTypedField(3, new CX[0]);
        return retVal;
    }

    public CX[] getPid3_PatientIdentifierList() {
        CX[] retVal = (CX[])this.getTypedField(3, new CX[0]);
        return retVal;
    }

    public int getPatientIdentifierListReps() {
        return this.getReps(3);
    }

    public CX getPatientIdentifierList(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public CX getPid3_PatientIdentifierList(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPid3_PatientIdentifierListReps() {
        return this.getReps(3);
    }

    public CX insertPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX insertPid3_PatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX removePatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX removePid3_PatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX[] getAlternatePatientIDPID() {
        CX[] retVal = (CX[])this.getTypedField(4, new CX[0]);
        return retVal;
    }

    public CX[] getPid4_AlternatePatientIDPID() {
        CX[] retVal = (CX[])this.getTypedField(4, new CX[0]);
        return retVal;
    }

    public int getAlternatePatientIDPIDReps() {
        return this.getReps(4);
    }

    public CX getAlternatePatientIDPID(int rep) {
        CX retVal = (CX)this.getTypedField(4, rep);
        return retVal;
    }

    public CX getPid4_AlternatePatientIDPID(int rep) {
        CX retVal = (CX)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPid4_AlternatePatientIDPIDReps() {
        return this.getReps(4);
    }

    public CX insertAlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(4, rep);
    }

    public CX insertPid4_AlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(4, rep);
    }

    public CX removeAlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(4, rep);
    }

    public CX removePid4_AlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(4, rep);
    }

    public XPN[] getPatientName() {
        XPN[] retVal = (XPN[])this.getTypedField(5, new XPN[0]);
        return retVal;
    }

    public XPN[] getPid5_PatientName() {
        XPN[] retVal = (XPN[])this.getTypedField(5, new XPN[0]);
        return retVal;
    }

    public int getPatientNameReps() {
        return this.getReps(5);
    }

    public XPN getPatientName(int rep) {
        XPN retVal = (XPN)this.getTypedField(5, rep);
        return retVal;
    }

    public XPN getPid5_PatientName(int rep) {
        XPN retVal = (XPN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPid5_PatientNameReps() {
        return this.getReps(5);
    }

    public XPN insertPatientName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(5, rep);
    }

    public XPN insertPid5_PatientName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(5, rep);
    }

    public XPN removePatientName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(5, rep);
    }

    public XPN removePid5_PatientName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(5, rep);
    }

    public XPN[] getMotherSMaidenName() {
        XPN[] retVal = (XPN[])this.getTypedField(6, new XPN[0]);
        return retVal;
    }

    public XPN[] getPid6_MotherSMaidenName() {
        XPN[] retVal = (XPN[])this.getTypedField(6, new XPN[0]);
        return retVal;
    }

    public int getMotherSMaidenNameReps() {
        return this.getReps(6);
    }

    public XPN getMotherSMaidenName(int rep) {
        XPN retVal = (XPN)this.getTypedField(6, rep);
        return retVal;
    }

    public XPN getPid6_MotherSMaidenName(int rep) {
        XPN retVal = (XPN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPid6_MotherSMaidenNameReps() {
        return this.getReps(6);
    }

    public XPN insertMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN insertPid6_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN removeMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public XPN removePid6_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public TS getDateTimeOfBirth() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getPid7_DateTimeOfBirth() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getAdministrativeSex() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getPid8_AdministrativeSex() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public XPN[] getPatientAlias() {
        XPN[] retVal = (XPN[])this.getTypedField(9, new XPN[0]);
        return retVal;
    }

    public XPN[] getPid9_PatientAlias() {
        XPN[] retVal = (XPN[])this.getTypedField(9, new XPN[0]);
        return retVal;
    }

    public int getPatientAliasReps() {
        return this.getReps(9);
    }

    public XPN getPatientAlias(int rep) {
        XPN retVal = (XPN)this.getTypedField(9, rep);
        return retVal;
    }

    public XPN getPid9_PatientAlias(int rep) {
        XPN retVal = (XPN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPid9_PatientAliasReps() {
        return this.getReps(9);
    }

    public XPN insertPatientAlias(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN insertPid9_PatientAlias(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN removePatientAlias(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public XPN removePid9_PatientAlias(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public CE[] getRace() {
        CE[] retVal = (CE[])this.getTypedField(10, new CE[0]);
        return retVal;
    }

    public CE[] getPid10_Race() {
        CE[] retVal = (CE[])this.getTypedField(10, new CE[0]);
        return retVal;
    }

    public int getRaceReps() {
        return this.getReps(10);
    }

    public CE getRace(int rep) {
        CE retVal = (CE)this.getTypedField(10, rep);
        return retVal;
    }

    public CE getPid10_Race(int rep) {
        CE retVal = (CE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getPid10_RaceReps() {
        return this.getReps(10);
    }

    public CE insertRace(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE insertPid10_Race(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE removeRace(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public CE removePid10_Race(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public XAD[] getPatientAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public XAD[] getPid11_PatientAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public int getPatientAddressReps() {
        return this.getReps(11);
    }

    public XAD getPatientAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getPid11_PatientAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPid11_PatientAddressReps() {
        return this.getReps(11);
    }

    public XAD insertPatientAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertPid11_PatientAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removePatientAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removePid11_PatientAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public IS getCountyCode() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public IS getPid12_CountyCode() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public XTN[] getPhoneNumberHome() {
        XTN[] retVal = (XTN[])this.getTypedField(13, new XTN[0]);
        return retVal;
    }

    public XTN[] getPid13_PhoneNumberHome() {
        XTN[] retVal = (XTN[])this.getTypedField(13, new XTN[0]);
        return retVal;
    }

    public int getPhoneNumberHomeReps() {
        return this.getReps(13);
    }

    public XTN getPhoneNumberHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(13, rep);
        return retVal;
    }

    public XTN getPid13_PhoneNumberHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPid13_PhoneNumberHomeReps() {
        return this.getReps(13);
    }

    public XTN insertPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN insertPid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN removePhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN removePid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN[] getPhoneNumberBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(14, new XTN[0]);
        return retVal;
    }

    public XTN[] getPid14_PhoneNumberBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(14, new XTN[0]);
        return retVal;
    }

    public int getPhoneNumberBusinessReps() {
        return this.getReps(14);
    }

    public XTN getPhoneNumberBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public XTN getPid14_PhoneNumberBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPid14_PhoneNumberBusinessReps() {
        return this.getReps(14);
    }

    public XTN insertPhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN insertPid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN removePhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public XTN removePid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public CE getPrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getPid15_PrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getMaritalStatus() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getPid16_MaritalStatus() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getReligion() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getPid17_Religion() {
        CE retVal = (CE)this.getTypedField(17, 0);
        return retVal;
    }

    public CX getPatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(18, 0);
        return retVal;
    }

    public CX getPid18_PatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getSSNNumberPatient() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getPid19_SSNNumberPatient() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public DLN getDriverSLicenseNumberPatient() {
        DLN retVal = (DLN)this.getTypedField(20, 0);
        return retVal;
    }

    public DLN getPid20_DriverSLicenseNumberPatient() {
        DLN retVal = (DLN)this.getTypedField(20, 0);
        return retVal;
    }

    public CX[] getMotherSIdentifier() {
        CX[] retVal = (CX[])this.getTypedField(21, new CX[0]);
        return retVal;
    }

    public CX[] getPid21_MotherSIdentifier() {
        CX[] retVal = (CX[])this.getTypedField(21, new CX[0]);
        return retVal;
    }

    public int getMotherSIdentifierReps() {
        return this.getReps(21);
    }

    public CX getMotherSIdentifier(int rep) {
        CX retVal = (CX)this.getTypedField(21, rep);
        return retVal;
    }

    public CX getPid21_MotherSIdentifier(int rep) {
        CX retVal = (CX)this.getTypedField(21, rep);
        return retVal;
    }

    public int getPid21_MotherSIdentifierReps() {
        return this.getReps(21);
    }

    public CX insertMotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(21, rep);
    }

    public CX insertPid21_MotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(21, rep);
    }

    public CX removeMotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(21, rep);
    }

    public CX removePid21_MotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(21, rep);
    }

    public CE[] getEthnicGroup() {
        CE[] retVal = (CE[])this.getTypedField(22, new CE[0]);
        return retVal;
    }

    public CE[] getPid22_EthnicGroup() {
        CE[] retVal = (CE[])this.getTypedField(22, new CE[0]);
        return retVal;
    }

    public int getEthnicGroupReps() {
        return this.getReps(22);
    }

    public CE getEthnicGroup(int rep) {
        CE retVal = (CE)this.getTypedField(22, rep);
        return retVal;
    }

    public CE getPid22_EthnicGroup(int rep) {
        CE retVal = (CE)this.getTypedField(22, rep);
        return retVal;
    }

    public int getPid22_EthnicGroupReps() {
        return this.getReps(22);
    }

    public CE insertEthnicGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(22, rep);
    }

    public CE insertPid22_EthnicGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(22, rep);
    }

    public CE removeEthnicGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(22, rep);
    }

    public CE removePid22_EthnicGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(22, rep);
    }

    public ST getBirthPlace() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getPid23_BirthPlace() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getMultipleBirthIndicator() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getPid24_MultipleBirthIndicator() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getBirthOrder() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getPid25_BirthOrder() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public CE[] getCitizenship() {
        CE[] retVal = (CE[])this.getTypedField(26, new CE[0]);
        return retVal;
    }

    public CE[] getPid26_Citizenship() {
        CE[] retVal = (CE[])this.getTypedField(26, new CE[0]);
        return retVal;
    }

    public int getCitizenshipReps() {
        return this.getReps(26);
    }

    public CE getCitizenship(int rep) {
        CE retVal = (CE)this.getTypedField(26, rep);
        return retVal;
    }

    public CE getPid26_Citizenship(int rep) {
        CE retVal = (CE)this.getTypedField(26, rep);
        return retVal;
    }

    public int getPid26_CitizenshipReps() {
        return this.getReps(26);
    }

    public CE insertCitizenship(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(26, rep);
    }

    public CE insertPid26_Citizenship(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(26, rep);
    }

    public CE removeCitizenship(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(26, rep);
    }

    public CE removePid26_Citizenship(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(26, rep);
    }

    public CE getVeteransMilitaryStatus() {
        CE retVal = (CE)this.getTypedField(27, 0);
        return retVal;
    }

    public CE getPid27_VeteransMilitaryStatus() {
        CE retVal = (CE)this.getTypedField(27, 0);
        return retVal;
    }

    public CE getNationality() {
        CE retVal = (CE)this.getTypedField(28, 0);
        return retVal;
    }

    public CE getPid28_Nationality() {
        CE retVal = (CE)this.getTypedField(28, 0);
        return retVal;
    }

    public TS getPatientDeathDateAndTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public TS getPid29_PatientDeathDateAndTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getPatientDeathIndicator() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getPid30_PatientDeathIndicator() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getIdentityUnknownIndicator() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getPid31_IdentityUnknownIndicator() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public IS[] getIdentityReliabilityCode() {
        IS[] retVal = (IS[])this.getTypedField(32, new IS[0]);
        return retVal;
    }

    public IS[] getPid32_IdentityReliabilityCode() {
        IS[] retVal = (IS[])this.getTypedField(32, new IS[0]);
        return retVal;
    }

    public int getIdentityReliabilityCodeReps() {
        return this.getReps(32);
    }

    public IS getIdentityReliabilityCode(int rep) {
        IS retVal = (IS)this.getTypedField(32, rep);
        return retVal;
    }

    public IS getPid32_IdentityReliabilityCode(int rep) {
        IS retVal = (IS)this.getTypedField(32, rep);
        return retVal;
    }

    public int getPid32_IdentityReliabilityCodeReps() {
        return this.getReps(32);
    }

    public IS insertIdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(32, rep);
    }

    public IS insertPid32_IdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(32, rep);
    }

    public IS removeIdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(32, rep);
    }

    public IS removePid32_IdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(32, rep);
    }

    public TS getLastUpdateDateTime() {
        TS retVal = (TS)this.getTypedField(33, 0);
        return retVal;
    }

    public TS getPid33_LastUpdateDateTime() {
        TS retVal = (TS)this.getTypedField(33, 0);
        return retVal;
    }

    public HD getLastUpdateFacility() {
        HD retVal = (HD)this.getTypedField(34, 0);
        return retVal;
    }

    public HD getPid34_LastUpdateFacility() {
        HD retVal = (HD)this.getTypedField(34, 0);
        return retVal;
    }

    public CE getSpeciesCode() {
        CE retVal = (CE)this.getTypedField(35, 0);
        return retVal;
    }

    public CE getPid35_SpeciesCode() {
        CE retVal = (CE)this.getTypedField(35, 0);
        return retVal;
    }

    public CE getBreedCode() {
        CE retVal = (CE)this.getTypedField(36, 0);
        return retVal;
    }

    public CE getPid36_BreedCode() {
        CE retVal = (CE)this.getTypedField(36, 0);
        return retVal;
    }

    public ST getStrain() {
        ST retVal = (ST)this.getTypedField(37, 0);
        return retVal;
    }

    public ST getPid37_Strain() {
        ST retVal = (ST)this.getTypedField(37, 0);
        return retVal;
    }

    public CE getProductionClassCode() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public CE getPid38_ProductionClassCode() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE[] getTribalCitizenship() {
        CWE[] retVal = (CWE[])this.getTypedField(39, new CWE[0]);
        return retVal;
    }

    public CWE[] getPid39_TribalCitizenship() {
        CWE[] retVal = (CWE[])this.getTypedField(39, new CWE[0]);
        return retVal;
    }

    public int getTribalCitizenshipReps() {
        return this.getReps(39);
    }

    public CWE getTribalCitizenship(int rep) {
        CWE retVal = (CWE)this.getTypedField(39, rep);
        return retVal;
    }

    public CWE getPid39_TribalCitizenship(int rep) {
        CWE retVal = (CWE)this.getTypedField(39, rep);
        return retVal;
    }

    public int getPid39_TribalCitizenshipReps() {
        return this.getReps(39);
    }

    public CWE insertTribalCitizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(39, rep);
    }

    public CWE insertPid39_TribalCitizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(39, rep);
    }

    public CWE removeTribalCitizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(39, rep);
    }

    public CWE removePid39_TribalCitizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(39, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new XPN(this.getMessage());
            }
            case 5: {
                return new XPN(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 8: {
                return new XPN(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new IS(this.getMessage(), new Integer(289));
            }
            case 12: {
                return new XTN(this.getMessage());
            }
            case 13: {
                return new XTN(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CX(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new DLN(this.getMessage());
            }
            case 20: {
                return new CX(this.getMessage());
            }
            case 21: {
                return new CE(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new CE(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 30: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 31: {
                return new IS(this.getMessage(), new Integer(445));
            }
            case 32: {
                return new TS(this.getMessage());
            }
            case 33: {
                return new HD(this.getMessage());
            }
            case 34: {
                return new CE(this.getMessage());
            }
            case 35: {
                return new CE(this.getMessage());
            }
            case 36: {
                return new ST(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

