/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_CONTAINER;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPL_O37_SPECIMEN
extends AbstractGroup {
    public OPL_O37_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OBX.class, false, true, false);
            this.add(OPL_O37_CONTAINER.class, false, true, false);
            this.add(OPL_O37_OBSERVATION_REQUEST.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OPL_O37_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public OPL_O37_CONTAINER getCONTAINER() {
        OPL_O37_CONTAINER retVal = this.getTyped("CONTAINER", OPL_O37_CONTAINER.class);
        return retVal;
    }

    public OPL_O37_CONTAINER getCONTAINER(int rep) {
        OPL_O37_CONTAINER retVal = this.getTyped("CONTAINER", rep, OPL_O37_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OPL_O37_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OPL_O37_CONTAINER.class);
    }

    public void insertCONTAINER(OPL_O37_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", structure, rep);
    }

    public OPL_O37_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OPL_O37_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OPL_O37_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OPL_O37_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OPL_O37_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OPL_O37_OBSERVATION_REQUEST retVal = this.getTyped("OBSERVATION_REQUEST", OPL_O37_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public OPL_O37_OBSERVATION_REQUEST getOBSERVATION_REQUEST(int rep) {
        OPL_O37_OBSERVATION_REQUEST retVal = this.getTyped("OBSERVATION_REQUEST", rep, OPL_O37_OBSERVATION_REQUEST.class);
        return retVal;
    }

    public int getOBSERVATION_REQUESTReps() {
        return this.getReps("OBSERVATION_REQUEST");
    }

    public List<OPL_O37_OBSERVATION_REQUEST> getOBSERVATION_REQUESTAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION_REQUEST", OPL_O37_OBSERVATION_REQUEST.class);
    }

    public void insertOBSERVATION_REQUEST(OPL_O37_OBSERVATION_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_REQUEST", structure, rep);
    }

    public OPL_O37_OBSERVATION_REQUEST insertOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_REQUEST)super.insertRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPL_O37_OBSERVATION_REQUEST removeOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_REQUEST)super.removeRepetition("OBSERVATION_REQUEST", rep);
    }
}

