/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.segment.CSP;
import ca.uhn.hl7v2.model.v26.segment.CSR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEX_P07_STUDY
extends AbstractGroup {
    public PEX_P07_STUDY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSR.class, true, false, false);
            this.add(CSP.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PEX_P07_STUDY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public CSR getCSR() {
        CSR retVal = this.getTyped("CSR", CSR.class);
        return retVal;
    }

    public CSP getCSP() {
        CSP retVal = this.getTyped("CSP", CSP.class);
        return retVal;
    }

    public CSP getCSP(int rep) {
        CSP retVal = this.getTyped("CSP", rep, CSP.class);
        return retVal;
    }

    public int getCSPReps() {
        return this.getReps("CSP");
    }

    public List<CSP> getCSPAll() throws HL7Exception {
        return this.getAllAsList("CSP", CSP.class);
    }

    public void insertCSP(CSP structure, int rep) throws HL7Exception {
        super.insertRepetition("CSP", structure, rep);
    }

    public CSP insertCSP(int rep) throws HL7Exception {
        return (CSP)super.insertRepetition("CSP", rep);
    }

    public CSP removeCSP(int rep) throws HL7Exception {
        return (CSP)super.removeRepetition("CSP", rep);
    }
}

