/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.segment.EVN;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import ca.uhn.hl7v2.model.v26.segment.PV2;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A61
extends AbstractMessage {
    public ADT_A61() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A61(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ROL.class, false, true);
            this.add(PV1.class, true, false);
            this.add(ROL.class, false, true);
            this.add(PV2.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_A61 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public ROL getROL2() {
        return this.getTyped("ROL2", ROL.class);
    }

    public ROL getROL2(int rep) {
        return this.getTyped("ROL2", rep, ROL.class);
    }

    public int getROL2Reps() {
        return this.getReps("ROL2");
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }
}

