/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.ORU_R30_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.ORU_R30_TIMING_QTY;
import ca.uhn.hl7v2.model.v26.group.ORU_R30_VISIT;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORU_R30
extends AbstractMessage {
    public ORU_R30() {
        this(new DefaultModelClassFactory());
    }

    public ORU_R30(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(OBX.class, false, true);
            this.add(ORU_R30_VISIT.class, false, false);
            this.add(ORC.class, true, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(ROL.class, false, true);
            this.add(ORU_R30_TIMING_QTY.class, false, true);
            this.add(ORU_R30_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORU_R30 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public OBX getOBX() {
        return this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public ORU_R30_VISIT getVISIT() {
        return this.getTyped("VISIT", ORU_R30_VISIT.class);
    }

    public ORC getORC() {
        return this.getTyped("ORC", ORC.class);
    }

    public OBR getOBR() {
        return this.getTyped("OBR", OBR.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public ORU_R30_TIMING_QTY getTIMING_QTY() {
        return this.getTyped("TIMING_QTY", ORU_R30_TIMING_QTY.class);
    }

    public ORU_R30_TIMING_QTY getTIMING_QTY(int rep) {
        return this.getTyped("TIMING_QTY", rep, ORU_R30_TIMING_QTY.class);
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<ORU_R30_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", ORU_R30_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(ORU_R30_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", structure, rep);
    }

    public ORU_R30_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R30_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public ORU_R30_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (ORU_R30_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public ORU_R30_OBSERVATION getOBSERVATION() {
        return this.getTyped("OBSERVATION", ORU_R30_OBSERVATION.class);
    }

    public ORU_R30_OBSERVATION getOBSERVATION(int rep) {
        return this.getTyped("OBSERVATION", rep, ORU_R30_OBSERVATION.class);
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<ORU_R30_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORU_R30_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORU_R30_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public ORU_R30_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R30_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R30_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R30_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

