/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelClassFactory
implements ModelClassFactory {
    protected static final String DEFAULT_EVENT_MAP_DIRECTORY = "ca/uhn/hl7v2/parser/eventmap/";
    private String eventMapDirectory = "ca/uhn/hl7v2/parser/eventmap/";
    private Map<Version, Map<String, String>> eventMap;

    public String getEventMapDirectory() {
        return this.eventMapDirectory;
    }

    public void setEventMapDirectory(String eventMapPrefix) {
        this.eventMapDirectory = eventMapPrefix;
    }

    @Override
    public String getMessageStructureForEvent(String name, Version version) throws HL7Exception {
        Map<String, String> p = this.getEventMapForVersion(version);
        if (p == null) {
            throw new HL7Exception("No map found for version " + (Object)((Object)version) + ". Only the following are available: " + this.getEventMap().keySet());
        }
        return p.get(name);
    }

    public Map<String, String> getEventMapForVersion(Version version) throws HL7Exception {
        return this.getEventMap().get((Object)version);
    }

    synchronized Map<Version, Map<String, String>> getEventMap() throws HL7Exception {
        if (this.eventMap == null) {
            try {
                this.eventMap = this.loadMessageStructures();
            }
            catch (IOException e) {
                throw new HL7Exception("Could not load event map", e);
            }
        }
        return this.eventMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Version, Map<String, String>> loadMessageStructures() throws IOException {
        HashMap<Version, Map<String, String>> map = new HashMap<Version, Map<String, String>>();
        for (Version v : Version.values()) {
            String resource = this.getEventMapDirectory() + v.getVersion() + ".properties";
            InputStream in = this.getResource(resource);
            if (in == null) continue;
            try {
                Properties structures = new Properties();
                structures.load(in);
                HashMap<String, String> structureMap = new HashMap<String, String>();
                for (Map.Entry<Object, Object> next : structures.entrySet()) {
                    structureMap.put((String)next.getKey(), (String)next.getValue());
                }
                map.put(v, Collections.unmodifiableMap(structureMap));
            }
            finally {
                in.close();
            }
        }
        return map;
    }

    private InputStream getResource(String resource) {
        InputStream in = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null && (loader = AbstractModelClassFactory.class.getClassLoader()) != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        return in;
    }
}

