/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal.context;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.bean.BeanMessages;

@ApplicationScoped
@Alternative
public class ContextProxy
implements Context {
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();

    public Property getProperty(String name) {
        return ContextProxy.getContext().getProperty(name);
    }

    public Property getProperty(String name, Scope scope) {
        return ContextProxy.getContext().getProperty(name, scope);
    }

    public <T> T getPropertyValue(String name) {
        return (T)ContextProxy.getContext().getPropertyValue(name);
    }

    public Set<Property> getProperties() {
        return ContextProxy.getContext().getProperties();
    }

    public Set<Property> getProperties(Scope scope) {
        return ContextProxy.getContext().getProperties(scope);
    }

    public void removeProperty(Property property) {
        ContextProxy.getContext().removeProperty(property);
    }

    public void removeProperties() {
        ContextProxy.getContext().removeProperties();
    }

    public void removeProperties(Scope scope) {
        ContextProxy.getContext().removeProperties(scope);
    }

    public Property setProperty(String name, Object val) {
        return ContextProxy.getContext().setProperty(name, val);
    }

    public Property setProperty(String name, Object val, Scope scope) {
        return ContextProxy.getContext().setProperty(name, val, scope);
    }

    public Context setProperties(Set<Property> properties) {
        return ContextProxy.getContext().setProperties(properties);
    }

    public void mergeInto(Context context) {
        ContextProxy.getContext().mergeInto(context);
    }

    public Set<Property> getProperties(String label) {
        return ContextProxy.getContext().getProperties(label);
    }

    public void removeProperties(String label) {
        ContextProxy.getContext().removeProperties(label);
    }

    private static Context getContext() {
        Context context = CONTEXT.get();
        if (context == null) {
            throw BeanMessages.MESSAGES.illegalCallToGetTheSwitchYardContextMustBeCalledWithinTheExecutionOfAnExchangeHandlerChain();
        }
        return context;
    }

    public static Context setContext(Context context) {
        Context orig = CONTEXT.get();
        if (context != null) {
            CONTEXT.set(context);
        } else {
            CONTEXT.remove();
        }
        return orig;
    }
}

