/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractCxfBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected void mapToProperty(BeanDefinitionBuilder bean, String propertyName, String val) {
        if ("id".equals(propertyName)) {
            return;
        }
        if (org.springframework.util.StringUtils.hasText((String)val)) {
            if (val.startsWith("#")) {
                Map<String, Object> map = this.getPropertyMap(bean, true);
                map.put(propertyName, val);
            } else {
                bean.addPropertyValue(propertyName, (Object)val);
            }
        }
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        super.doParse(element, ctx, bean);
        bean.setLazyInit(false);
        Map<String, Object> map = this.getPropertyMap(bean, true);
        map.put("beanId", this.resolveId(element, bean.getBeanDefinition(), ctx));
        bean.setScope("prototype");
    }

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = super.resolveId(elem, definition, ctx);
        if (StringUtils.isEmpty((String)id)) {
            throw new BeanDefinitionStoreException("The bean id is needed.");
        }
        return id;
    }

    protected boolean hasBusProperty() {
        return true;
    }

    protected Map<String, Object> getPropertyMap(BeanDefinitionBuilder bean, boolean lazyInstantiation) {
        PropertyValue propertyValue = bean.getBeanDefinition().getPropertyValues().getPropertyValue("properties");
        HashMap map = null;
        if (propertyValue == null) {
            if (lazyInstantiation) {
                map = new HashMap();
                bean.addPropertyValue("properties", map);
            }
        } else {
            map = (HashMap)propertyValue.getValue();
        }
        return map;
    }
}

