/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import org.switchyard.SwitchYardException;
import org.switchyard.common.io.Buffers;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.io.pull.Puller;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.pull.KeyStorePuller;

public final class PublicCrypto {
    private static final String FORMAT = PublicCrypto.class.getSimpleName() + "@%s[key=%s, publicKey=%s, keyTransformation=%s]";
    public static final String KEYSTORE_LOCATION = "keyStoreLocation";
    public static final String KEYSTORE_TYPE = "keyStoreType";
    public static final String KEYSTORE_PASSWORD = "keyStorePassword";
    public static final String KEY_ALIAS = "keyAlias";
    public static final String KEY_PASSWORD = "keyPassword";
    public static final String KEY_TRANSFORMATION = "keyTransformation";
    private Key _key = null;
    private PublicKey _publicKey = null;
    private String _keyTransformation = null;

    public PublicCrypto(String keyStoreLocation, String keyStoreType, char[] keyStorePassword, String keyAlias, char[] keyPassword, String keyTransformation) {
        this.init(keyStoreLocation, keyStoreType, keyStorePassword, keyAlias, keyPassword, keyTransformation);
    }

    public PublicCrypto(Map<String, String> map) {
        this(new PropertiesPuller().pull(map));
    }

    public PublicCrypto(Properties properties) {
        String keyStoreLocation = Strings.trimToNull((String)properties.getProperty(KEYSTORE_LOCATION));
        String keyStoreType = Strings.trimToNull((String)properties.getProperty(KEYSTORE_TYPE));
        String keyStorePasswordProperty = properties.getProperty(KEYSTORE_PASSWORD);
        char[] keyStorePassword = keyStorePasswordProperty != null ? keyStorePasswordProperty.toCharArray() : null;
        String keyAlias = Strings.trimToNull((String)properties.getProperty(KEY_ALIAS));
        String keyPasswordProperty = properties.getProperty(KEY_PASSWORD);
        char[] keyPassword = keyPasswordProperty != null ? keyPasswordProperty.toCharArray() : null;
        String keyTransformation = Strings.trimToNull((String)properties.getProperty(KEY_TRANSFORMATION));
        this.init(keyStoreLocation, keyStoreType, keyStorePassword, keyAlias, keyPassword, keyTransformation);
    }

    private void init(String keyStoreLocation, String keyStoreType, char[] keyStorePassword, String keyAlias, char[] keyPassword, String keyTransformation) {
        if (keyStoreLocation == null) {
            return;
        }
        KeyStorePuller keyStorePuller = new KeyStorePuller(keyStoreType, keyStorePassword);
        KeyStore keyStore = (KeyStore)keyStorePuller.pullPath(keyStoreLocation, this.getClass(), Puller.PathType.values());
        try {
            Certificate certificate = keyStore.getCertificate(keyAlias);
            this._publicKey = certificate.getPublicKey();
            this._keyTransformation = keyTransformation != null ? keyTransformation : this._publicKey.getAlgorithm();
        }
        catch (KeyStoreException kse) {
            throw new SwitchYardException((Throwable)kse);
        }
    }

    public byte[] encrypt(Serializable object) {
        try {
            int bufLength;
            ByteArrayOutputStream encOut = new ByteArrayOutputStream();
            ByteArrayInputStream objIn = new ByteArrayInputStream(this.toBytes(object));
            byte[] buf = Buffers.newDefaultBuffer();
            Cipher cipher = Cipher.getInstance(this._keyTransformation);
            cipher.init(1, this._publicKey);
            while ((bufLength = objIn.read(buf)) != -1) {
                byte[] encBytes = cipher.doFinal(this.copyBytes(buf, bufLength));
                encOut.write(encBytes);
            }
            encOut.flush();
            return encOut.toByteArray();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public Serializable decrypt(byte[] bytes) {
        try {
            int bufLength;
            ByteArrayInputStream encIn = new ByteArrayInputStream(bytes);
            ByteArrayOutputStream decOut = new ByteArrayOutputStream();
            byte[] buf = Buffers.newDefaultBuffer();
            Cipher cipher = Cipher.getInstance(this._keyTransformation);
            cipher.init(2, this._key);
            while ((bufLength = encIn.read(buf)) != -1) {
                byte[] decBytes = cipher.doFinal(this.copyBytes(buf, bufLength));
                decOut.write(decBytes);
            }
            decOut.flush();
            return this.toSerializable(decOut.toByteArray());
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private byte[] copyBytes(byte[] src, int length) {
        if (src.length == length) {
            return src;
        }
        byte[] dest = new byte[length];
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toBytes(Serializable object) throws IOException {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable toSerializable(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
        }
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._key, this._publicKey, this._keyTransformation);
    }
}

