/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.switchyard.SwitchYardException;
import org.switchyard.validate.internal.DuplicateValidatorException;

@MessageBundle(projectCode="SWITCHYARD")
public interface ValidateMessages {
    public static final ValidateMessages MESSAGES = (ValidateMessages)Messages.getBundle(ValidateMessages.class);

    @Message(id=17200, value="Null 'validatorRegistry' argument.")
    public IllegalArgumentException nullValidatorRegistryArgument();

    @Message(id=17201, value="Error reading out-of-the-box Validator configurations from classpath (%s).")
    public SwitchYardException errorReadingValidator(String var1, @Cause IOException var2);

    @Message(id=17202, value="Failed to register Validator '%s'.  A Validator for these types is already registered: '%s'.")
    public DuplicateValidatorException failedToRegisterValidator(String var1, String var2);

    @Message(id=17203, value="CDI BeanManager couldn't be found. A Java validator class name must be specified if CDI is not enabled.")
    public SwitchYardException cdiBeanManagerNotFound();

    @Message(id=17204, value="The Java validator bean '%s' couldn't be found in CDI registry.")
    public SwitchYardException validatorBeanNotFound(String var1);

    @Message(id=17205, value="'bean' or 'class' must be specified for Java validator definition.")
    public SwitchYardException beanOrClassRequired();

    @Message(id=17206, value="Error constructing Validator instance for class '%s'.")
    public SwitchYardException errorConstructingValidator(String var1, @Cause Exception var2);

    @Message(id=17207, value="Unknown ValidateModel type '%s'.")
    public SwitchYardException unknownValidateModel(String var1);

    @Message(id=17208, value="Invalid Validator class '%s'.  Must implement the Validator interface, or have methods annotated with the @Validator annotation.")
    public SwitchYardException invalidValidatorClass(String var1);

    @Message(id=17209, value="Error constructing Validator instance for class '%s'.  Class must have a public default constructor.")
    public SwitchYardException errorConstructingValidatorConstructorRequired(String var1, @Cause Exception var2);

    @Message(id=17210, value="Error constructing Validator instance for class '%s'.  Class does not support a validation for type '%s'.")
    public SwitchYardException errorConstructingValidatorClassNotSupported(String var1, String var2);

    @Message(id=17211, value="Error constructing Validator instance for class '%s'.  Class must have a public default constructor.")
    public SwitchYardException errorConstructingValidatorMustHavePublicConstructor(String var1, @Cause Exception var2);

    @Message(id=17212, value="Invalid method signature: @Validator method '%s' on class '%s' must return org.switchyard.validate.ValidationResult.")
    public SwitchYardException invalidMethodSignatureMustReturnValidationResult(String var1, String var2);

    @Message(id=17213, value="Error executing @Validator method '%s' on class '%s'.")
    public SwitchYardException errorExecutingValidatorInvocationTargetException(String var1, String var2, @Cause InvocationTargetException var3);

    @Message(id=17214, value="Error executing @Validator method '%s' on class '%s'.")
    public SwitchYardException errorExecutingValidatorException(String var1, String var2, @Cause Exception var3);

    @Message(id=17215, value="Invalid @Validator method '%s' on class '%s'.  Must have exactly 1 parameter.")
    public SwitchYardException invalidValidatorOneParameter(String var1, String var2);

    @Message(id=17216, value="ValidateModel type '%s' is not annotated with an @ValidatorFactoryClass annotation.")
    public SwitchYardException validateModelNotAnnotated(String var1);

    @Message(id=17217, value="Invalid ValidatorFactory implementation.  Must implement '%s'.")
    public SwitchYardException invalidValidatorFactoryImplementation(String var1);

    @Message(id=17218, value="Failed to create an instance of ValidatorFactory '%s'.  Class must have a public default constructor and not be abstract.")
    public SwitchYardException failedToInstantiateValidatorFactory(String var1);

    @Message(id=17219, value="Could not instantiate XmlValidator: schemaType must be specified.")
    public SwitchYardException couldNotInstantiateXmlValidator();

    @Message(id=17220, value="Could not instantiate XmlValidator: schemaType '%s' is invalid.It must be the one of %s.")
    public SwitchYardException couldNotInstantiateXmlValidatorBadSchemaType(String var1, String var2);

    @Message(id=17221, value="Schema file must be specified for %s validation.")
    public SwitchYardException schemaFileMustBeSpecified(String var1);

    @Message(id=17222, value="No valid schema file was found.")
    public SwitchYardException noValidSchemaFileFound();

    @Message(id=17223, value="Please check the switchyard validator configuration.  No DTD file is specified : %s")
    public IOException noDTDFile(String var1);
}

