/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import org.switchyard.ServiceMetadata;
import org.switchyard.ServiceReference;
import org.switchyard.admin.Throttling;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseService;
import org.switchyard.config.model.composite.ExtensionsModel;
import org.switchyard.config.model.switchyard.ThrottlingModel;
import org.switchyard.metadata.ServiceMetadataBuilder;

public class ServiceThrottling
implements Throttling {
    private final BaseService _service;
    private boolean _enabled = false;
    private int _maxRequests;
    private long _timePeriod = 1000L;

    public ServiceThrottling(BaseService service, ExtensionsModel extensions) {
        this._service = service;
        if (extensions == null) {
            return;
        }
        ThrottlingModel throttling = extensions.getThrottling();
        if (throttling == null) {
            return;
        }
        this._maxRequests = throttling.getMaxRequests();
        this._enabled = true;
        Long timePeriod = throttling.getTimePeriod();
        if (timePeriod != null) {
            this._timePeriod = timePeriod;
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void enable() {
        this.update(true, null);
    }

    @Override
    public void disable() {
        this.update(false, null);
    }

    @Override
    public int getMaxRequests() {
        return this._maxRequests;
    }

    @Override
    public void setMaxRequests(int maxRequests) {
        this.update(null, maxRequests);
    }

    @Override
    public long getTimePeriod() {
        return this._timePeriod;
    }

    @Override
    public void update(Boolean enabled, Integer maxRequests) {
        boolean doUpdate = false;
        if (maxRequests != null && maxRequests != this._maxRequests) {
            this._maxRequests = maxRequests;
            doUpdate = this._enabled;
        }
        if (enabled != null && enabled != this._enabled) {
            this._enabled = enabled;
            doUpdate = true;
        }
        if (doUpdate) {
            this.updateThrottler();
        }
    }

    private void updateThrottler() {
        org.switchyard.metadata.qos.Throttling throttling;
        if (this._enabled) {
            throttling = new org.switchyard.metadata.qos.Throttling();
            throttling.setMaxRequests(this._maxRequests);
            throttling.setTimePeriod(this._timePeriod);
        } else {
            throttling = null;
        }
        BaseApplication application = (BaseApplication)this._service.getApplication();
        ServiceReference serviceReference = application.getDeployment().getDomain().getServiceReference(this._service.getName());
        ServiceMetadataBuilder.update((ServiceMetadata)serviceReference.getServiceMetadata()).throttling(throttling);
    }
}

