/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model.internal;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.milyn.config.Configurable;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.DecodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNode
extends MappingNode {
    private String dataType;
    private List<Map.Entry<String, String>> parameters;
    private Integer minLength;
    private Integer maxLength;
    private DataDecoder decoder;
    private Class<?> typeClass;
    private Properties decodeParams;

    public ValueNode() {
    }

    public ValueNode(String xmltag, String namespace) {
        super(xmltag, namespace);
        this.minLength = 0;
        this.maxLength = 1;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
        if (dataType != null) {
            this.decoder = DataDecoder.Factory.create(dataType);
            DecodeType decodeType = this.decoder.getClass().getAnnotation(DecodeType.class);
            if (decodeType != null) {
                this.typeClass = decodeType.value()[0];
            }
        }
    }

    public DataDecoder getDecoder() {
        return this.decoder;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public List<Map.Entry<String, String>> getTypeParameters() {
        return this.parameters;
    }

    public void setDataTypeParameters(List<Map.Entry<String, String>> parameters) {
        this.parameters = parameters;
        if (this.decoder instanceof Configurable) {
            if (this.decoder == null) {
                throw new IllegalStateException("Illegal call to set parameters before 'dataType' has been configured on the " + this.getClass().getName());
            }
            this.decodeParams = new Properties();
            if (parameters != null) {
                for (Map.Entry<String, String> entry : parameters) {
                    this.decodeParams.setProperty(entry.getKey(), entry.getValue());
                }
            }
            ((Configurable)((Object)this.decoder)).setConfiguration(this.decodeParams);
        }
    }

    public String getDataTypeParametersString() {
        if (this.parameters == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> parameter : this.parameters) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(parameter.getKey());
            builder.append("=");
            builder.append(parameter.getValue());
        }
        return builder.toString();
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void isValidForType(String value) throws DataDecodeException {
        this.decoder.decode(value);
    }
}

