/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import javax.xml.soap.SOAPException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.switchyard.HandlerException;
import org.switchyard.SwitchYardException;
import org.switchyard.component.soap.WebServicePublishException;

@MessageBundle(projectCode="SWITCHYARD")
public interface SOAPMessages {
    public static final SOAPMessages MESSAGES = (SOAPMessages)Messages.getBundle(SOAPMessages.class);

    @Message(id=35401, value="Missing SOAP body from request")
    public SOAPException missingSOAPBodyFromRequest();

    @Message(id=35402, value="Found multiple SOAPElements in SOAPBody")
    public SOAPException foundMultipleSOAPElementsInSOAPBody();

    @Message(id=35403, value="Could not find SOAPElement in SOAPBody")
    public SOAPException couldNotFindSOAPElementInSOAPBody();

    @Message(id=35404, value="Content-ID header missing for attachment part")
    public SOAPException contentIDHeaderMissingForAttachmentPart();

    @Message(id=35405, value="Unable to read WSDL at %s")
    public String unableToReadWSDL(String var1);

    @Message(id=35406, value="Unable to create SOAP Body due to null message content")
    public SOAPException unableToCreateSOAPBodyDueToNullMessageContent();

    @Message(id=35407, value="Unable to parse SOAP Message")
    public SOAPException unableToParseSOAPMessage(@Cause Exception var1);

    @Message(id=35408, value="Failed to map context properties to SOAP message")
    public SOAPException failedToMapContextPropertiesToSOAPMessage(@Cause Exception var1);

    @Message(id=35409, value="not %s")
    public IllegalArgumentException not(String var1);

    @Message(id=35410, value="Unable to resolve WSDL document at %s")
    public String unableToResolveWSDL(String var1);

    @Message(id=35411, value="Unexpected SOAPException when generating a SOAP 1.1 Fault message.")
    public IllegalStateException unexpectedSOAPExceptionWhenGeneratingASOAP11FaultMessage(@Cause Exception var1);

    @Message(id=35412, value="Unexpected SOAPException when generating a SOAP 1.2 Fault message.")
    public IllegalStateException unexpectedSOAPExceptionWhenGeneratingASOAP12FaultMessage(@Cause Exception var1);

    @Message(id=35418, value="Unexpected")
    public IllegalStateException unexpected();

    @Message(id=35422, value="Invalid input SOAP payload for service operation '%s' (service '%s').  No such Part '%s'.")
    public SOAPException invalidInputSOAPPayloadForServiceOperation(String var1, String var2, String var3);

    @Message(id=35423, value="Invalid input SOAP payload namespace for service operation '%s' (service '%s').  Port defines operation namespace as '%s'.  Actual namespace on input SOAP message '%s'.")
    public SOAPException invalidInputSOAPPayloadNamespaceForServiceOperation(String var1, String var2, String var3, String var4);

    @Message(id=35424, value="Invalid input SOAP payload localNamePart for service operation '%s' (service '%s').  Port defines operation localNamePart as '%s'.  Actual localNamePart on input SOAP message '%s'.")
    public SOAPException invalidInputSOAPPayloadLocalNamePartForServiceOperation(String var1, String var2, String var3, String var4);

    @Message(id=35427, value="Reference binding \"%s/%s\" is not started.")
    public HandlerException referenceBindingNotStarted(String var1, String var2);

    @Message(id=35428, value="Failed to instantiate SOAP Message Factory")
    public SOAPException failedToInstantiateSOAPMessageFactory();

    @Message(id=35429, value="Unexpected exception handling SOAP Message")
    public HandlerException unexpectedExceptionHandlingSOAPMessage(@Cause SOAPException var1);

    @Message(id=35431, value="Cannot process SOAP request")
    public SOAPException cannotProcessSOAPRequest(@Cause Exception var1);

    @Message(id=35433, value="No attachment found with name '%s'")
    public RuntimeException noAttachmentFoundWithName(String var1);

    @Message(id=35436, value="Could not find service %s in the WSDL %s")
    public String couldNotFindServiceInTheWSDL(String var1, String var2);

    @Message(id=35437, value="Could not find a port definition within service %s")
    public String couldNotFindAPortDefinitionWithinService(String var1);

    @Message(id=35438, value="Could not find port %s in the Service %s")
    public String couldNotFindPortInTheService(String var1, String var2);

    @Message(id=35439, value="Incompatible style of soap operation level bindings detected")
    public SwitchYardException incompatibleStyleOfSoapOperationLevelBindingsDetected();

    @Message(id=35440, value="Detected mixing different soap binding style on port type and operation level")
    public SwitchYardException detectedMixingDifferentSoapBindingStyleOnPortTypeAndOperationLevel();

    @Message(id=35441, value="Fault name %s not found on operation %s")
    public IllegalArgumentException faultNameNotFoundOnOperation(String var1, String var2);

    @Message(id=35442, value="Policy reference URI missing for %s")
    public RuntimeException policyReferenceURIMissingFor(String var1);

    @Message(id=35443, value="Invalid WSDL. No operations found.")
    public WebServicePublishException invalidWSDLNoOperationsFound();

    @Message(id=35444, value="WSDL Operation %s not found in Service %s")
    public WebServicePublishException wSDLOperationNotFoundInService(String var1, String var2);

    @Message(id=35445, value="WSDL Operation %s does not match Service Operation %s")
    public WebServicePublishException wSDLOperationDoesNotMatchServiceOperation(String var1, String var2);

    @Message(id=35446, value="WSDL Operation %s does not have any input Message parts")
    public WebServicePublishException wSDLOperationDoesNotHaveAnyInputMessageParts(String var1);

    @Message(id=35447, value="WSDL Operation %s does not have any ouput Message parts")
    public WebServicePublishException wSDLOperationDoesNotHaveAnyOuputMessageParts(String var1);

    @Message(id=35448, value="Send Failed")
    public String sendFailed();

    @Message(id=35449, value="No such operation: %s->null")
    public SOAPException noSuchOperation(String var1);

    @Message(id=35450, value="Could not find any operation associated with WS-A Action '%s'.")
    public SOAPException couldNotFindOperation(String var1);

    @Message(id=35451, value="Operation for '%s' not available on target Service '%s'.")
    public SOAPException operationNotAvailableTarget(String var1, String var2);

    @Message(id=35452, value="Timed out after %s ms waiting on synchronous response from target service '%s'.")
    public SOAPException timedOut(String var1, String var2);

    @Message(id=35453, value="Invalid response SOAPMessage construction.  The associated SwitchYard Exchange is in a FAULT state, but the SOAPMessage is not a Fault message.  The MessageComposer implementation in use (\"%s\") must generate the SOAPMessage instance properly as a Fault message.")
    public SOAPException invalidResponseConstruction(String var1);

    @Message(id=35454, value="Could not instantiate interceptor class: %s")
    public SwitchYardException couldNotInstantiateInterceptor(String var1, @Cause Throwable var2);
}

