/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.soup.CommChannel;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.apache.ode.utils.CollectionUtils;

public class ChannelFactory {
    private static final Method METHOD_OBJECT_EQUALS;
    private static final Method METHOD_CHANNEL_EXPORT;

    public static Object getBackend(Channel channel) {
        ChannelInvocationHandler cih = (ChannelInvocationHandler)Proxy.getInvocationHandler(channel);
        return cih._backend;
    }

    public static Channel createChannel(CommChannel backend, Class type) {
        ChannelInvocationHandler h = new ChannelInvocationHandler(backend);
        Class[] ifaces = new Class[]{Channel.class, type};
        Object proxy = Proxy.newProxyInstance(Channel.class.getClassLoader(), ifaces, (InvocationHandler)h);
        return (Channel)proxy;
    }

    static {
        try {
            METHOD_OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)"No equals(Object) method on Object!");
        }
        try {
            METHOD_CHANNEL_EXPORT = Channel.class.getMethod("export", CollectionUtils.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            throw new AssertionError((Object)"No export() method on Object!");
        }
    }

    public static final class ChannelInvocationHandler
    implements InvocationHandler {
        private CommChannel _backend;

        ChannelInvocationHandler(CommChannel backend) {
            this._backend = backend;
        }

        public String toString() {
            return this._backend.toString();
        }

        public boolean equals(Object other) {
            return ((ChannelInvocationHandler)other)._backend.equals(this._backend);
        }

        public int hashCode() {
            return this._backend.hashCode();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method.equals(METHOD_OBJECT_EQUALS)) {
                    return this.equals(Proxy.getInvocationHandler(args[0]));
                }
                return method.invoke((Object)this, args);
            }
            if (method.equals(METHOD_CHANNEL_EXPORT)) {
                return JacobVPU.activeJacobThread().exportChannel((Channel)proxy);
            }
            return JacobVPU.activeJacobThread().message((Channel)proxy, method, args);
        }
    }
}

