/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.resteasy.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.switchyard.common.type.reflect.Access;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.resteasy.InboundHandler;
import org.switchyard.component.resteasy.composer.RESTEasyBindingData;

public final class RESTEasyProxy
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(RESTEasyProxy.class);
    private static final Access<HttpServletRequest> SERVLET_REQUEST_ACCESS;
    private InboundHandler _serviceConsumer;

    public static Object newInstance(InboundHandler serviceConsumer, Class<?> interfaze) {
        return Proxy.newProxyInstance(interfaze.getClassLoader(), new Class[]{interfaze}, (InvocationHandler)new RESTEasyProxy(serviceConsumer));
    }

    private RESTEasyProxy(InboundHandler serviceConsumer) {
        this._serviceConsumer = serviceConsumer;
    }

    public void setConsumer(InboundHandler serviceConsumer) {
        this._serviceConsumer = serviceConsumer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SecurityContext securityContext;
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("equals")) {
            return this.equals(proxy);
        }
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        RESTEasyBindingData requestData = new RESTEasyBindingData();
        HttpHeaders headers = (HttpHeaders)ResteasyProviderFactory.getContextData(HttpHeaders.class);
        if (headers != null) {
            requestData.setHeaders((MultivaluedMap<String, String>)headers.getRequestHeaders());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)"Incoming Headers to SwitchYard through InboundHandler [");
                RESTEasyProxy.traceLog(LOGGER, (Map<String, List<String>>)headers.getRequestHeaders());
                LOGGER.trace((Object)"]");
            }
        }
        if ((securityContext = (SecurityContext)ResteasyProviderFactory.getContextData(SecurityContext.class)) != null) {
            if (securityContext instanceof ServletSecurityContext && SERVLET_REQUEST_ACCESS != null) {
                HttpServletRequest servletRequest = (HttpServletRequest)SERVLET_REQUEST_ACCESS.read((Object)((ServletSecurityContext)securityContext));
                requestData.setServletRequest((ServletRequest)servletRequest);
            }
            requestData.setSecured(securityContext.isSecure());
            requestData.setPrincipal(securityContext.getUserPrincipal());
        }
        requestData.setOperationName(methodName);
        if (args != null && args.length > 0) {
            requestData.setParameters(args);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)args);
            }
        }
        RESTEasyBindingData responseData = this._serviceConsumer.invoke(requestData, method.getReturnType().equals(Void.TYPE));
        Response.ResponseBuilder builder = Response.ok();
        if (responseData != null) {
            if (method.getReturnType().equals(Response.class)) {
                if (responseData.getParameters().length > 0) {
                    Object param = responseData.getParameters()[0];
                    if (param instanceof Response) {
                        Response response = (Response)param;
                        builder.entity(response.getEntity());
                        builder.status(response.getStatus());
                    } else {
                        builder.entity(param);
                    }
                }
                if (responseData.getStatusCode() != null) {
                    builder.status(responseData.getStatusCode().intValue());
                }
                for (Map.Entry entry : responseData.getHeaders().entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    for (String value : values) {
                        builder.header(name, (Object)value);
                    }
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"Outgoing Headers from SwitchYard through InboundHandler [");
                    RESTEasyProxy.traceLog(LOGGER, responseData.getHeaders());
                    LOGGER.trace((Object)"]");
                }
            } else if (responseData.getParameters().length > 0) {
                return responseData.getParameters()[0];
            }
        }
        return builder.build();
    }

    public static void traceLog(Logger logger2, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                logger2.trace((Object)(name + " = " + value));
            }
        }
    }

    static {
        FieldAccess servletRequestAccess = new FieldAccess(ServletSecurityContext.class, "request");
        SERVLET_REQUEST_ACCESS = servletRequestAccess.isReadable() ? servletRequestAccess : null;
    }
}

