/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.serial.graph;

import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.serial.SerialMessages;
import org.switchyard.serial.graph.BaseFactory;
import org.switchyard.serial.graph.node.Node;
import org.switchyard.serial.graph.node.ThrowableAccessNode;

public class ThrowableFactory<T>
extends BaseFactory<T> {
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{String.class}, new Class[0]};

    @Override
    public boolean supports(Class<?> type) {
        if (type != null) {
            return UndeclaredThrowableException.class.equals(type) || this.getConstructor(type) != null;
        }
        return false;
    }

    @Override
    public T create(Class<T> type, Node node) {
        Object obj = null;
        if (type != null) {
            String message;
            String string = message = node instanceof ThrowableAccessNode ? ((ThrowableAccessNode)node).getMessage() : null;
            if (UndeclaredThrowableException.class.equals(type)) {
                return type.cast(new UndeclaredThrowableException(null, message));
            }
            Constructor<T> constructor = this.getConstructor(type);
            Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
            try {
                if (parameterTypes.length == 0) {
                    obj = Construction.construct(type);
                } else if (parameterTypes.length == 1) {
                    obj = Construction.construct(type, (Class[])parameterTypes, (Object[])new Object[]{message});
                }
            }
            catch (Throwable t) {
                throw SerialMessages.MESSAGES.couldNotInstantiateThrowable(type.getName(), t.getMessage());
            }
        }
        return (T)obj;
    }

    private Constructor<?> getConstructor(Class<?> type) {
        Constructor<?> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = type.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }
}

