/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.mbean.internal;

import java.util.ArrayList;
import java.util.List;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.ServiceOperation;
import org.switchyard.admin.mbean.ApplicationMXBean;
import org.switchyard.admin.mbean.ComponentServiceMXBean;
import org.switchyard.admin.mbean.internal.ManagedApplication;

public class ManagedComponentService
implements ComponentServiceMXBean {
    private ComponentService _service;
    private ManagedApplication _parent;

    public ManagedComponentService(ComponentService service, ManagedApplication parent) {
        this._service = service;
        this._parent = parent;
    }

    @Override
    public String getName() {
        return this._service.getName().toString();
    }

    @Override
    public String getInterface() {
        return this._service.getInterface();
    }

    @Override
    public ApplicationMXBean getApplication() {
        return this._parent;
    }

    @Override
    public String getImplementation() {
        return this._service.getImplementation();
    }

    @Override
    public String getImplementationConfiguration() {
        return this._service.getImplementationConfiguration();
    }

    @Override
    public List<String> getServiceOperations() {
        ArrayList<String> ops = new ArrayList<String>();
        for (ServiceOperation op : this._service.getServiceOperations()) {
            ops.add(op.getName());
        }
        return ops;
    }

    @Override
    public List<String> getReferences() {
        ArrayList<String> refs = new ArrayList<String>();
        for (ComponentReference ref : this._service.getReferences()) {
            refs.add(ref.getName().toString());
        }
        return refs;
    }

    @Override
    public int getSuccessCount() {
        return this._service.getMessageMetrics().getSuccessCount();
    }

    @Override
    public int getFaultCount() {
        return this._service.getMessageMetrics().getFaultCount();
    }

    @Override
    public int getTotalCount() {
        return this._service.getMessageMetrics().getTotalCount();
    }

    @Override
    public long getTotalProcessingTime() {
        return this._service.getMessageMetrics().getTotalProcessingTime();
    }

    @Override
    public double getAverageProcessingTime() {
        return this._service.getMessageMetrics().getAverageProcessingTime();
    }

    @Override
    public int getMinProcessingTime() {
        return this._service.getMessageMetrics().getMinProcessingTime();
    }

    @Override
    public int getMaxProcessingTime() {
        return this._service.getMessageMetrics().getMaxProcessingTime();
    }

    @Override
    public void reset() {
        this._service.resetMessageMetrics();
    }
}

