/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.infinispan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.switchyard.remote.RemoteEndpoint;
import org.switchyard.remote.RemoteLogger;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public class InfinispanRegistry
implements RemoteRegistry {
    private static final QName ROOT_DOMAIN = new QName("all-domains");
    private static Logger _log = Logger.getLogger(InfinispanRegistry.class);
    private String _nodeName;
    private Cache<String, String> _serviceCache;
    private Serializer _serializer;

    public InfinispanRegistry(Cache<String, String> serviceCache) {
        this._serviceCache = serviceCache;
        this._serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
        serviceCache.getCacheManager().addListener((Object)new MemberDropListener());
        this._nodeName = serviceCache.getCacheManager().getAddress().toString();
    }

    @Override
    public void addEndpoint(RemoteEndpoint endpoint) {
        String cacheKey = this.createNodeKey(ROOT_DOMAIN, endpoint.getServiceName(), this._nodeName);
        if (this._serviceCache.get((Object)cacheKey) != null) {
            RemoteLogger.ROOT_LOGGER.remoteEndpointRegistered(cacheKey);
            return;
        }
        try {
            endpoint.setNode(this._nodeName);
            String epStr = new String(this._serializer.serialize((Object)endpoint, RemoteEndpoint.class));
            this._serviceCache.put((Object)cacheKey, (Object)epStr);
            if (_log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder().append("Added Endpoint:[").append("EndpointAddress='").append(endpoint.getEndpoint()).append("'").append(", NodeName='").append(endpoint.getNode()).append("'").append(", DomainName='").append(endpoint.getDomainName()).append("'").append(", ServiceName='").append(endpoint.getServiceName()).append("'").append(", ServiceContract='").append(endpoint.getContract()).append("'").append("]");
                _log.debug((Object)buf.toString());
            }
        }
        catch (IOException ioEx) {
            RemoteLogger.ROOT_LOGGER.failedAddEndpoint(cacheKey, ioEx);
        }
    }

    @Override
    public void removeEndpoint(RemoteEndpoint endpoint) {
        if (this._nodeName != null) {
            this._serviceCache.remove((Object)this.createNodeKey(ROOT_DOMAIN, endpoint.getServiceName(), this._nodeName));
            if (_log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder().append("Removed Endpoint:[").append("EndpointAddress='").append(endpoint.getEndpoint()).append("'").append(", NodeName='").append(endpoint.getNode()).append("'").append(", DomainName='").append(endpoint.getDomainName()).append("'").append(", ServiceName='").append(endpoint.getServiceName()).append("'").append(", ServiceContract='").append(endpoint.getContract()).append("'").append("]");
                _log.debug((Object)buf.toString());
            }
        }
    }

    @Override
    public List<RemoteEndpoint> getEndpoints(QName serviceName) {
        LinkedList<RemoteEndpoint> services = new LinkedList<RemoteEndpoint>();
        String serviceKey = this.createServiceKey(ROOT_DOMAIN, serviceName);
        Set nodes = this._serviceCache.keySet();
        if (nodes != null) {
            for (String node : nodes) {
                String epStr;
                if (!node.startsWith(serviceKey) || (epStr = (String)this._serviceCache.get((Object)node)) == null) continue;
                try {
                    RemoteEndpoint ep = (RemoteEndpoint)this._serializer.deserialize(epStr.getBytes(), RemoteEndpoint.class);
                    services.add(ep);
                }
                catch (IOException ioEx) {
                    _log.warn((Object)("Failed to deserialize remote endpoint: " + epStr), (Throwable)ioEx);
                }
            }
        }
        return services;
    }

    private String createServiceKey(QName domain, QName service) {
        return "/" + domain.toString() + "/" + service.toString();
    }

    private String createNodeKey(QName domain, QName service, String node) {
        return this.createServiceKey(domain, service) + "/" + node;
    }

    @Listener
    public class MemberDropListener {
        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            ArrayList dropped = new ArrayList(event.getOldMembers());
            dropped.removeAll(event.getNewMembers());
            for (Address addr : dropped) {
                this.dropAllServices(addr);
            }
        }

        void dropAllServices(Address address) {
            for (String node : InfinispanRegistry.this._serviceCache.keySet()) {
                if (!node.endsWith("/" + address.toString())) continue;
                InfinispanRegistry.this._serviceCache.remove((Object)node);
            }
        }
    }
}

