/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca;

import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SCALogger;
import org.switchyard.component.sca.SCAMessages;
import org.switchyard.config.model.composite.SCABindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.remote.RemoteEndpoint;
import org.switchyard.remote.RemoteRegistry;

public class SCAEndpoint
extends BaseServiceHandler {
    private RemoteEndpointPublisher _endpointPublisher;
    private ServiceDomain _domain;
    private RemoteRegistry _registry;
    private RemoteEndpoint _endpoint;
    private SCABindingModel _bindingModel;

    public SCAEndpoint(SCABindingModel bindingModel, ServiceDomain domain, RemoteEndpointPublisher endpointPublisher, RemoteRegistry registry) {
        super(domain);
        this._bindingModel = bindingModel;
        this._endpointPublisher = endpointPublisher;
        this._domain = domain;
        this._registry = registry;
    }

    protected void doStart() {
        QName serviceName = this._bindingModel.getService().getQName();
        this._endpointPublisher.addService(serviceName, this._domain);
        List services = this._domain.getServices(serviceName);
        if (services.isEmpty()) {
            throw SCAMessages.MESSAGES.failedToResolveServiceInDomain(serviceName.toString());
        }
        if (this._bindingModel.isClustered()) {
            if (this._registry != null) {
                this._endpoint = RemoteEndpoint.fromService((Service)((Service)services.get(0)));
                this._endpoint.setEndpoint(this._endpointPublisher.getAddress());
                this._registry.addEndpoint(this._endpoint);
            } else {
                SCALogger.ROOT_LOGGER.cannotEnableClusteredSCABindingFor(serviceName.toString());
            }
        }
    }

    protected void doStop() {
        if (this._bindingModel.isClustered() && this._registry != null) {
            this._registry.removeEndpoint(this._endpoint);
        }
        this._endpointPublisher.removeService(this._bindingModel.getService().getQName(), this._domain);
    }

    public RemoteEndpointPublisher getEndpointPublisher() {
        return this._endpointPublisher;
    }
}

