/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.spi.UriEndpoint;
import org.fusesource.camel.component.sap.FunctionHandlerFactory;
import org.fusesource.camel.component.sap.SapRfcServerEndpoint;
import org.fusesource.camel.component.sap.SapSynchronousRfcConsumer;
import org.fusesource.camel.component.sap.SapSynchronousRfcServerComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-srfc-server", consumerClass=SapSynchronousRfcConsumer.class, syntax="sap-srfc-server:serverName:rfcName")
public class SapSynchronousRfcServerEndpoint
extends SapRfcServerEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapSynchronousRfcServerEndpoint.class);

    public SapSynchronousRfcServerEndpoint() {
    }

    public SapSynchronousRfcServerEndpoint(String endpointUri, SapSynchronousRfcServerComponent component) {
        super(endpointUri, (Component)component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.debug("Created consumer for endpoint '" + this.getEndpointUri() + "'");
        FunctionHandlerFactory handlerFactory = this.getComponent().getServerHandlerFactory(this.serverName);
        if (handlerFactory == null) {
            throw new IllegalStateException("Function Handler Factory for '" + this.serverName + "' missing.");
        }
        SapSynchronousRfcConsumer consumer = new SapSynchronousRfcConsumer(this, processor);
        if (this.isStateful()) {
            consumer.setStateful(true);
        }
        handlerFactory.registerHandler(this.getRfcName(), consumer);
        return consumer;
    }

    public SapSynchronousRfcServerComponent getComponent() {
        return (SapSynchronousRfcServerComponent)super.getComponent();
    }
}

