/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.fusesource.camel.component.sap.IDocHandlerFactory;
import org.fusesource.camel.component.sap.SapTransactionalIDocListServerEndpoint;
import org.fusesource.camel.component.sap.ServerErrorAndExceptionListener;
import org.fusesource.camel.component.sap.ServerStateChangedListener;
import org.fusesource.camel.component.sap.ServerTIDHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapTransactionalIDocListServerComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocListServerComponent.class);
    protected File tidStoresLocation = new File(".");
    protected Map<String, JCoIDocServer> activeServers = new HashMap<String, JCoIDocServer>();
    protected ServerErrorAndExceptionListener serverErrorAndExceptionListener = new ServerErrorAndExceptionListener();
    protected ServerStateChangedListener serverStateChangedListener = new ServerStateChangedListener();

    public SapTransactionalIDocListServerComponent() {
        super(SapTransactionalIDocListServerEndpoint.class);
    }

    public String getTidStoresLocation() {
        return this.tidStoresLocation.getAbsolutePath();
    }

    public void setTidStoresLocation(String tidStoresLocation) {
        this.tidStoresLocation = new File(tidStoresLocation);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (!uri.startsWith("sap-idoclist-server:")) {
            throw new IllegalArgumentException("The URI '" + uri + "' has invalid scheme; should be 'sap-idoclist-server:'");
        }
        String[] uriComponents = remaining.split(":");
        if (uriComponents.length < 2) {
            throw new IllegalArgumentException("URI must be of the form: sap-idoc-server:<serverName>:<idocType>[:<idocTypeExtension>[:<systemRelease>[:<applicationRelease>]]]");
        }
        parameters.put("serverName", uriComponents[0]);
        parameters.put("idocType", uriComponents[1]);
        if (uriComponents.length > 2) {
            parameters.put("idocTypeExtension", uriComponents[2]);
        }
        if (uriComponents.length > 3) {
            parameters.put("systemRelease", uriComponents[3]);
        }
        if (uriComponents.length > 4) {
            parameters.put("applicationRelease", uriComponents[4]);
        }
        SapTransactionalIDocListServerEndpoint endpoint = new SapTransactionalIDocListServerEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        LOG.debug("Created endpoint '" + uri + "'");
        endpoint.createDocumentList();
        return endpoint;
    }

    protected synchronized JCoIDocServer getServer(String serverName) throws Exception {
        JCoIDocServer server = this.activeServers.get(serverName);
        if (server == null) {
            server = JCoIDoc.getServer((String)serverName);
            server.setIDocHandlerFactory((JCoIDocHandlerFactory)new IDocHandlerFactory());
            File tidStoreFile = new File(this.tidStoresLocation, serverName);
            server.setTIDHandler((JCoServerTIDHandler)new ServerTIDHandler(tidStoreFile));
            server.addServerExceptionListener((JCoServerExceptionListener)this.serverErrorAndExceptionListener);
            server.addServerErrorListener((JCoServerErrorListener)this.serverErrorAndExceptionListener);
            server.addServerStateChangedListener((JCoServerStateChangedListener)this.serverStateChangedListener);
            String repositoryDestinationName = server.getRepositoryDestination();
            JCoDestination repositoryDestination = null;
            try {
                repositoryDestination = JCoDestinationManager.getDestination((String)repositoryDestinationName);
            }
            catch (Exception e1) {
                LOG.warn("Unable to get repository destination'" + repositoryDestinationName + "' for server '" + serverName + "'", (Throwable)e1);
            }
            if (repositoryDestination != null) {
                try {
                    IDocRepository idocRepository = JCoIDoc.getIDocRepository((JCoDestination)repositoryDestination);
                    server.setIDocRepository(idocRepository);
                }
                catch (Exception e) {
                    LOG.warn("Unable to set IDoc repository on server '" + serverName + "'", (Throwable)e);
                }
            }
            this.activeServers.put(serverName, server);
            if (this.isStarted()) {
                server.start();
                LOG.debug("Started server " + server.getProgramID());
            }
        }
        return server;
    }

    protected IDocHandlerFactory getIDocHandlerFactory(String serverName) throws Exception {
        JCoIDocServer server = this.getServer(serverName);
        if (server == null) {
            return null;
        }
        return (IDocHandlerFactory)server.getIDocHandlerFactory();
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (JCoServer jCoServer : this.activeServers.values()) {
            jCoServer.start();
        }
        LOG.debug("STARTED");
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("STOPPED");
    }
}

