/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.fusesource.camel.component.sap.FunctionHandlerFactory;
import org.fusesource.camel.component.sap.SapRfcServerEndpoint;
import org.fusesource.camel.component.sap.SapTransactionalRfcConsumer;
import org.fusesource.camel.component.sap.SapTransactionalRfcServerComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-trfc-server", consumerClass=SapTransactionalRfcConsumer.class, syntax="sap-trfc-server:serverName:rfcName")
public class SapTransactionalRfcServerEndpoint
extends SapRfcServerEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalRfcServerEndpoint.class);
    @UriParam
    protected boolean propagateExceptions;

    public SapTransactionalRfcServerEndpoint() {
    }

    public SapTransactionalRfcServerEndpoint(String endpointUri, SapTransactionalRfcServerComponent component) {
        super(endpointUri, (Component)component);
    }

    public boolean isPropagateExceptions() {
        return this.propagateExceptions;
    }

    public void setPropagateExceptions(boolean propagateExceptions) {
        this.propagateExceptions = propagateExceptions;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.debug("Created consumer for endpoint '" + this.getEndpointUri() + "'");
        FunctionHandlerFactory handlerFactory = this.getComponent().getServerHandlerFactory(this.serverName);
        if (handlerFactory == null) {
            throw new IllegalStateException("Function Handler Factory for '" + this.serverName + "' missing.");
        }
        SapTransactionalRfcConsumer consumer = new SapTransactionalRfcConsumer(this, processor);
        if (this.isStateful()) {
            consumer.setStateful(true);
        }
        handlerFactory.registerHandler(this.getRfcName(), consumer);
        return consumer;
    }

    public SapTransactionalRfcServerComponent getComponent() {
        return (SapTransactionalRfcServerComponent)super.getComponent();
    }
}

