/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Converter;
import org.eclipse.emf.ecore.EObject;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.impl.StructureImpl;
import org.fusesource.camel.component.sap.util.Util;

@Converter
public enum StructureConverter {
    INSTANCE;


    @Converter
    public static Structure toStructure(String string) {
        try {
            EObject eObject = Util.unmarshal(string);
            if (StructureImpl.class.isInstance(eObject)) {
                return (StructureImpl)eObject;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Converter
    public static Structure toStructure(InputStream in) {
        try {
            EObject eObject = Util.fromInputStream(in);
            if (StructureImpl.class.isInstance(eObject)) {
                return (StructureImpl)eObject;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Converter
    public static Structure toStructure(byte[] byteArray) {
        try {
            EObject eObject = Util.unmarshal(new String(byteArray));
            if (StructureImpl.class.isInstance(eObject)) {
                return (StructureImpl)eObject;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Converter
    public static String toString(StructureImpl structure) {
        try {
            return Util.marshal(structure);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Converter
    public static OutputStream toOutputStream(StructureImpl structure) {
        try {
            return Util.toOutputStream(structure);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Converter
    public static InputStream toInputStream(StructureImpl structure) {
        try {
            return Util.toInputStream(structure);
        }
        catch (IOException e) {
            return null;
        }
    }
}

