/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.services;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.switchyard.as7.extension.ExtensionLogger;
import org.switchyard.config.Configuration;
import org.switchyard.config.ConfigurationPuller;
import org.switchyard.config.Configurations;
import org.switchyard.deploy.Component;

public class SwitchYardComponentService
implements Service<Component> {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"SwitchYardComponentService"});
    private final InjectedValue<Map> _injectedValues = new InjectedValue();
    private final InjectedValue<ResourceAdapterRepository> _resourceAdapterRepository = new InjectedValue();
    private String _moduleId;
    private ModelNode _model;
    private Component _component;

    public SwitchYardComponentService(String moduleId, ModelNode model) {
        this._moduleId = moduleId;
        this._model = model;
    }

    public Component getValue() throws IllegalStateException, IllegalArgumentException {
        return this._component;
    }

    public void start(StartContext context) throws StartException {
        String className = this._model.get("implClass").asString();
        try {
            Class componentClass = Module.loadClassFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)this._moduleId), (String)className);
            try {
                this._component = (Component)componentClass.newInstance();
                ModelNode properties = this._model.hasDefined("properties") ? this._model.get("properties") : null;
                this._component.init(this.createEnvironmentConfig(properties));
                LOG.debug((Object)("Initialized component " + this._component));
                this._component.addResourceDependency(this._resourceAdapterRepository.getValue());
            }
            catch (InstantiationException ie) {
                ExtensionLogger.ROOT_LOGGER.unableToInstantiateClass(className, ie);
            }
            catch (IllegalAccessException iae) {
                ExtensionLogger.ROOT_LOGGER.unableToAccessConstructor(className, iae);
            }
        }
        catch (ClassNotFoundException cnfe) {
            ExtensionLogger.ROOT_LOGGER.unableToLoadClass(className, cnfe);
        }
        catch (ModuleLoadException mle) {
            ExtensionLogger.ROOT_LOGGER.unableToLoadModule(this._moduleId, mle);
        }
    }

    private Configuration createEnvironmentConfig(ModelNode properties) {
        Set propertyNames;
        Configuration envConfig = Configurations.newConfiguration();
        if (properties != null && (propertyNames = properties.keys()) != null) {
            for (String propertyName : propertyNames) {
                Configuration propConfig = new ConfigurationPuller().pull(new QName(propertyName));
                String value = properties.get(propertyName).asString();
                if (value.startsWith("$")) {
                    String key = value.substring(1);
                    String injectedValue = (String)((Map)this._injectedValues.getValue()).get(key);
                    if (injectedValue == null) continue;
                    propConfig.setValue(injectedValue);
                    envConfig.addChild(propConfig);
                    continue;
                }
                propConfig.setValue(value);
                envConfig.addChild(propConfig);
            }
        }
        return envConfig;
    }

    public void stop(StopContext context) {
        LOG.info((Object)("Stopping SwitchYard component " + this._component.getName()));
        try {
            this._component.destroy();
        }
        catch (Exception e) {
            ExtensionLogger.ROOT_LOGGER.unableToStop(this._component.getName(), e);
        }
    }

    public InjectedValue<Map> getInjectedValues() {
        return this._injectedValues;
    }

    public Injector<ResourceAdapterRepository> getResourceAdapterRepository() {
        return this._resourceAdapterRepository;
    }
}

