/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.bpm.console.client.model.ParticipantRef;

@XmlRootElement(name="taskReference")
public class TaskRef {
    private long id;
    private String processInstanceId;
    private String processId;
    private String name;
    private String assignee = "";
    private boolean isBlocking;
    private boolean isSignalling = true;
    private List<String> outcomes = new ArrayList<String>();
    private STATE currentState;
    private List<ParticipantRef> participantUsers = new ArrayList<ParticipantRef>();
    private List<ParticipantRef> participantGroups = new ArrayList<ParticipantRef>();
    private String url;
    private Date dueDate;
    private Date createDate;
    private int priority;
    private String description;

    public TaskRef() {
        this.initOrUpdateState();
    }

    public TaskRef(long taskId, String processInstanceId, String processId, String taskName, String assignee, boolean blocking, boolean signalling) {
        this.id = taskId;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.name = taskName;
        this.setAssignee(assignee);
        this.isBlocking = blocking;
        this.isSignalling = signalling;
        this.initOrUpdateState();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        if (null == assignee) {
            assignee = "";
        }
        this.assignee = assignee;
        this.initOrUpdateState();
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean blocking) {
        this.isBlocking = blocking;
    }

    public boolean isSignalling() {
        return this.isSignalling;
    }

    public void setSignalling(boolean signalling) {
        this.isSignalling = signalling;
    }

    public List<String> getOutcomes() {
        return this.outcomes;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public List<ParticipantRef> getParticipantUsers() {
        return this.participantUsers;
    }

    public List<ParticipantRef> getParticipantGroups() {
        return this.participantGroups;
    }

    private void initOrUpdateState() {
        this.currentState = this.assignee == null || this.assignee.equals("") ? STATE.OPEN : STATE.ASSIGNED;
    }

    public void close() {
        if (STATE.ASSIGNED != this.currentState) {
            throw new IllegalArgumentException("Cannot close task in state " + (Object)((Object)this.currentState));
        }
        this.currentState = STATE.CLOSED;
    }

    public String getProcessId() {
        return this.processId;
    }

    public STATE getCurrentState() {
        return this.currentState;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "TaskRef{id:" + this.id + ",state:" + (Object)((Object)this.currentState) + "}";
    }

    public static enum STATE {
        OPEN,
        ASSIGNED,
        CLOSED;

    }
}

