/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Model;

public final class PolicyConfig {
    public static final String REQUIRES = "requires";

    private PolicyConfig() {
    }

    public static Set<QName> getRequirements(Model model) {
        return model.getModelConfiguration().getAttributeAsQNames(REQUIRES, " ");
    }

    public static void setRequirements(Model model, Set<QName> requirements) {
        Configuration config = model.getModelConfiguration();
        if (requirements == null || requirements.isEmpty()) {
            config.setAttribute(REQUIRES, null);
            return;
        }
        StringBuilder requires = new StringBuilder();
        for (QName req : requirements) {
            requires.append(" ");
            String ns = req.getNamespaceURI();
            if ("".equals(ns)) {
                requires.append(req.getLocalPart());
                continue;
            }
            String pfx = config.lookupPrefix(ns);
            if (pfx != null) {
                requires.append(pfx + ":" + req.getLocalPart());
                continue;
            }
            requires.append(req.getLocalPart());
        }
        config.setAttribute(REQUIRES, requires.toString().trim());
    }

    public static void addRequirement(Model model, QName qname) {
        Set<QName> requires = PolicyConfig.getRequirements(model);
        requires.add(qname);
        PolicyConfig.setRequirements(model, requires);
    }

    public static boolean hasRequirement(Model model, QName qname) {
        Set<QName> requirements = PolicyConfig.getRequirements(model);
        for (QName requirement : requirements) {
            if (requirement.equals(qname)) {
                return true;
            }
            if (!"".equals(requirement.getNamespaceURI()) || !requirement.getLocalPart().equals(qname.getLocalPart())) continue;
            return true;
        }
        return false;
    }
}

