/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.AD;
import ca.uhn.hl7v2.model.v21.datatype.CK;
import ca.uhn.hl7v2.model.v21.datatype.CM;
import ca.uhn.hl7v2.model.v21.datatype.DT;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.PN;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PID
extends AbstractSegment {
    public PID(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - PATIENT ID");
            this.add(CK.class, false, 1, 16, new Object[]{this.getMessage()}, "PATIENT ID EXTERNAL (EXTERNAL ID)");
            this.add(CK.class, true, 1, 16, new Object[]{this.getMessage()}, "PATIENT ID INTERNAL (INTERNAL ID)");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "ALTERNATE PATIENT ID");
            this.add(PN.class, true, 1, 48, new Object[]{this.getMessage()}, "PATIENT NAME");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "MOTHER'S MAIDEN NAME");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "DATE OF BIRTH");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "SEX");
            this.add(PN.class, false, 0, 48, new Object[]{this.getMessage()}, "PATIENT ALIAS");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(5)}, "ETHNIC GROUP");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "PATIENT ADDRESS");
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "COUNTY CODE");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "PHONE NUMBER - HOME");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "PHONE NUMBER - BUSINESS");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "LANGUAGE - PATIENT");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(2)}, "MARITAL STATUS");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(6)}, "RELIGION");
            this.add(CK.class, false, 1, 20, new Object[]{this.getMessage()}, "PATIENT ACCOUNT NUMBER");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "SSN NUMBER - PATIENT");
            this.add(CM.class, false, 1, 25, new Object[]{this.getMessage()}, "DRIVER'S LIC NUM - PATIENT");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PID - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDPATIENTID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPid1_SETIDPATIENTID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CK getPATIENTIDEXTERNALEXTERNALID() {
        CK retVal = (CK)this.getTypedField(2, 0);
        return retVal;
    }

    public CK getPid2_PATIENTIDEXTERNALEXTERNALID() {
        CK retVal = (CK)this.getTypedField(2, 0);
        return retVal;
    }

    public CK getPATIENTIDINTERNALINTERNALID() {
        CK retVal = (CK)this.getTypedField(3, 0);
        return retVal;
    }

    public CK getPid3_PATIENTIDINTERNALINTERNALID() {
        CK retVal = (CK)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getALTERNATEPATIENTID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPid4_ALTERNATEPATIENTID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public PN getPATIENTNAME() {
        PN retVal = (PN)this.getTypedField(5, 0);
        return retVal;
    }

    public PN getPid5_PATIENTNAME() {
        PN retVal = (PN)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getMOTHERSMAIDENNAME() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPid6_MOTHERSMAIDENNAME() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public DT getDATEOFBIRTH() {
        DT retVal = (DT)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getPid7_DATEOFBIRTH() {
        DT retVal = (DT)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getSEX() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getPid8_SEX() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public PN[] getPATIENTALIAS() {
        PN[] retVal = (PN[])this.getTypedField(9, new PN[0]);
        return retVal;
    }

    public PN[] getPid9_PATIENTALIAS() {
        PN[] retVal = (PN[])this.getTypedField(9, new PN[0]);
        return retVal;
    }

    public int getPATIENTALIASReps() {
        return this.getReps(9);
    }

    public PN getPATIENTALIAS(int rep) {
        PN retVal = (PN)this.getTypedField(9, rep);
        return retVal;
    }

    public PN getPid9_PATIENTALIAS(int rep) {
        PN retVal = (PN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPid9_PATIENTALIASReps() {
        return this.getReps(9);
    }

    public PN insertPATIENTALIAS(int rep) throws HL7Exception {
        return (PN)super.insertRepetition(9, rep);
    }

    public PN insertPid9_PATIENTALIAS(int rep) throws HL7Exception {
        return (PN)super.insertRepetition(9, rep);
    }

    public PN removePATIENTALIAS(int rep) throws HL7Exception {
        return (PN)super.removeRepetition(9, rep);
    }

    public PN removePid9_PATIENTALIAS(int rep) throws HL7Exception {
        return (PN)super.removeRepetition(9, rep);
    }

    public ID getETHNICGROUP() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPid10_ETHNICGROUP() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public AD getPATIENTADDRESS() {
        AD retVal = (AD)this.getTypedField(11, 0);
        return retVal;
    }

    public AD getPid11_PATIENTADDRESS() {
        AD retVal = (AD)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getCOUNTYCODE() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPid12_COUNTYCODE() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public TN[] getPHONENUMBERHOME() {
        TN[] retVal = (TN[])this.getTypedField(13, new TN[0]);
        return retVal;
    }

    public TN[] getPid13_PHONENUMBERHOME() {
        TN[] retVal = (TN[])this.getTypedField(13, new TN[0]);
        return retVal;
    }

    public int getPHONENUMBERHOMEReps() {
        return this.getReps(13);
    }

    public TN getPHONENUMBERHOME(int rep) {
        TN retVal = (TN)this.getTypedField(13, rep);
        return retVal;
    }

    public TN getPid13_PHONENUMBERHOME(int rep) {
        TN retVal = (TN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPid13_PHONENUMBERHOMEReps() {
        return this.getReps(13);
    }

    public TN insertPHONENUMBERHOME(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(13, rep);
    }

    public TN insertPid13_PHONENUMBERHOME(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(13, rep);
    }

    public TN removePHONENUMBERHOME(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(13, rep);
    }

    public TN removePid13_PHONENUMBERHOME(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(13, rep);
    }

    public TN[] getPHONENUMBERBUSINESS() {
        TN[] retVal = (TN[])this.getTypedField(14, new TN[0]);
        return retVal;
    }

    public TN[] getPid14_PHONENUMBERBUSINESS() {
        TN[] retVal = (TN[])this.getTypedField(14, new TN[0]);
        return retVal;
    }

    public int getPHONENUMBERBUSINESSReps() {
        return this.getReps(14);
    }

    public TN getPHONENUMBERBUSINESS(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public TN getPid14_PHONENUMBERBUSINESS(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPid14_PHONENUMBERBUSINESSReps() {
        return this.getReps(14);
    }

    public TN insertPHONENUMBERBUSINESS(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN insertPid14_PHONENUMBERBUSINESS(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN removePHONENUMBERBUSINESS(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public TN removePid14_PHONENUMBERBUSINESS(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public ST getLANGUAGEPATIENT() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getPid15_LANGUAGEPATIENT() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getMARITALSTATUS() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getPid16_MARITALSTATUS() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getRELIGION() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPid17_RELIGION() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public CK getPATIENTACCOUNTNUMBER() {
        CK retVal = (CK)this.getTypedField(18, 0);
        return retVal;
    }

    public CK getPid18_PATIENTACCOUNTNUMBER() {
        CK retVal = (CK)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getSSNNUMBERPATIENT() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getPid19_SSNNUMBERPATIENT() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public CM getDRIVERSLICNUMPATIENT() {
        CM retVal = (CM)this.getTypedField(20, 0);
        return retVal;
    }

    public CM getPid20_DRIVERSLICNUMPATIENT() {
        CM retVal = (CM)this.getTypedField(20, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CK(this.getMessage());
            }
            case 2: {
                return new CK(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new PN(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new DT(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(1));
            }
            case 8: {
                return new PN(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(5));
            }
            case 10: {
                return new AD(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 12: {
                return new TN(this.getMessage());
            }
            case 13: {
                return new TN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(2));
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(6));
            }
            case 17: {
                return new CK(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new CM(this.getMessage());
            }
        }
        return null;
    }
}

