/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.model.v23.datatype.TQ;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SCH
extends AbstractSegment {
    public SCH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 22, new Object[]{this.getMessage()}, "Placer Appointment ID");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Filler Appointment ID");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Occurrence Number");
            this.add(EI.class, false, 1, 37, new Object[]{this.getMessage()}, "Placer Group Number");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Schedule ID");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage()}, "Event Reason");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Appointment Reason");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Appointment Type");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Appointment Duration");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Appointment Duration Units");
            this.add(TQ.class, true, 0, 200, new Object[]{this.getMessage()}, "Appointment Timing Quantity");
            this.add(XCN.class, false, 1, 48, new Object[]{this.getMessage()}, "Placer Contact Person");
            this.add(XTN.class, false, 1, 40, new Object[]{this.getMessage()}, "Placer Contact Phone Number");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Placer Contact Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Placer Contact Location");
            this.add(XCN.class, true, 1, 38, new Object[]{this.getMessage()}, "Filler Contact Person");
            this.add(XTN.class, false, 1, 40, new Object[]{this.getMessage()}, "Filler Contact Phone Number");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Filler Contact Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Filler Contact Location");
            this.add(XCN.class, true, 1, 48, new Object[]{this.getMessage()}, "Entered By Person");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Entered By Phone Number");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Entered By Location");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Parent Placer Appointment ID");
            this.add(EI.class, false, 1, 75, new Object[]{this.getMessage()}, "Parent Filler Appointment ID");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Filler Status Code");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SCH - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getSch1_PlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSch2_FillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOccurrenceNumber() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getSch3_OccurrenceNumber() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getPlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getSch4_PlacerGroupNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getScheduleID() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getSch5_ScheduleID() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getEventReason() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getSch6_EventReason() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAppointmentReason() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getSch7_AppointmentReason() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAppointmentType() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getSch8_AppointmentType() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getAppointmentDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getSch9_AppointmentDuration() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getAppointmentDurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getSch10_AppointmentDurationUnits() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public TQ[] getAppointmentTimingQuantity() {
        TQ[] retVal = (TQ[])this.getTypedField(11, new TQ[0]);
        return retVal;
    }

    public TQ[] getSch11_AppointmentTimingQuantity() {
        TQ[] retVal = (TQ[])this.getTypedField(11, new TQ[0]);
        return retVal;
    }

    public int getAppointmentTimingQuantityReps() {
        return this.getReps(11);
    }

    public TQ getAppointmentTimingQuantity(int rep) {
        TQ retVal = (TQ)this.getTypedField(11, rep);
        return retVal;
    }

    public TQ getSch11_AppointmentTimingQuantity(int rep) {
        TQ retVal = (TQ)this.getTypedField(11, rep);
        return retVal;
    }

    public int getSch11_AppointmentTimingQuantityReps() {
        return this.getReps(11);
    }

    public TQ insertAppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(11, rep);
    }

    public TQ insertSch11_AppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.insertRepetition(11, rep);
    }

    public TQ removeAppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(11, rep);
    }

    public TQ removeSch11_AppointmentTimingQuantity(int rep) throws HL7Exception {
        return (TQ)super.removeRepetition(11, rep);
    }

    public XCN getPlacerContactPerson() {
        XCN retVal = (XCN)this.getTypedField(12, 0);
        return retVal;
    }

    public XCN getSch12_PlacerContactPerson() {
        XCN retVal = (XCN)this.getTypedField(12, 0);
        return retVal;
    }

    public XTN getPlacerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(13, 0);
        return retVal;
    }

    public XTN getSch13_PlacerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(13, 0);
        return retVal;
    }

    public XAD getPlacerContactAddress() {
        XAD retVal = (XAD)this.getTypedField(14, 0);
        return retVal;
    }

    public XAD getSch14_PlacerContactAddress() {
        XAD retVal = (XAD)this.getTypedField(14, 0);
        return retVal;
    }

    public PL getPlacerContactLocation() {
        PL retVal = (PL)this.getTypedField(15, 0);
        return retVal;
    }

    public PL getSch15_PlacerContactLocation() {
        PL retVal = (PL)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN getFillerContactPerson() {
        XCN retVal = (XCN)this.getTypedField(16, 0);
        return retVal;
    }

    public XCN getSch16_FillerContactPerson() {
        XCN retVal = (XCN)this.getTypedField(16, 0);
        return retVal;
    }

    public XTN getFillerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public XTN getSch17_FillerContactPhoneNumber() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public XAD getFillerContactAddress() {
        XAD retVal = (XAD)this.getTypedField(18, 0);
        return retVal;
    }

    public XAD getSch18_FillerContactAddress() {
        XAD retVal = (XAD)this.getTypedField(18, 0);
        return retVal;
    }

    public PL getFillerContactLocation() {
        PL retVal = (PL)this.getTypedField(19, 0);
        return retVal;
    }

    public PL getSch19_FillerContactLocation() {
        PL retVal = (PL)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getEnteredByPerson() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getSch20_EnteredByPerson() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XTN[] getEnteredByPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(21, new XTN[0]);
        return retVal;
    }

    public XTN[] getSch21_EnteredByPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(21, new XTN[0]);
        return retVal;
    }

    public int getEnteredByPhoneNumberReps() {
        return this.getReps(21);
    }

    public XTN getEnteredByPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(21, rep);
        return retVal;
    }

    public XTN getSch21_EnteredByPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(21, rep);
        return retVal;
    }

    public int getSch21_EnteredByPhoneNumberReps() {
        return this.getReps(21);
    }

    public XTN insertEnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN insertSch21_EnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(21, rep);
    }

    public XTN removeEnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public XTN removeSch21_EnteredByPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(21, rep);
    }

    public PL getEnteredByLocation() {
        PL retVal = (PL)this.getTypedField(22, 0);
        return retVal;
    }

    public PL getSch22_EnteredByLocation() {
        PL retVal = (PL)this.getTypedField(22, 0);
        return retVal;
    }

    public EI getParentPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getSch23_ParentPlacerAppointmentID() {
        EI retVal = (EI)this.getTypedField(23, 0);
        return retVal;
    }

    public EI getParentFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(24, 0);
        return retVal;
    }

    public EI getSch24_ParentFillerAppointmentID() {
        EI retVal = (EI)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getFillerStatusCode() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getSch25_FillerStatusCode() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new TQ(this.getMessage());
            }
            case 11: {
                return new XCN(this.getMessage());
            }
            case 12: {
                return new XTN(this.getMessage());
            }
            case 13: {
                return new XAD(this.getMessage());
            }
            case 14: {
                return new PL(this.getMessage());
            }
            case 15: {
                return new XCN(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new XAD(this.getMessage());
            }
            case 18: {
                return new PL(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new XTN(this.getMessage());
            }
            case 21: {
                return new PL(this.getMessage());
            }
            case 22: {
                return new EI(this.getMessage());
            }
            case 23: {
                return new EI(this.getMessage());
            }
            case 24: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

