/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.NMQ_N01_NCKNSTNSC;
import ca.uhn.hl7v2.model.v231.group.NMQ_N01_QRDQRF;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMQ_N01
extends AbstractMessage {
    public NMQ_N01() {
        this(new DefaultModelClassFactory());
    }

    public NMQ_N01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NMQ_N01_QRDQRF.class, false, false);
            this.add(NMQ_N01_NCKNSTNSC.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public NMQ_N01_QRDQRF getQRDQRF() {
        return this.getTyped("QRDQRF", NMQ_N01_QRDQRF.class);
    }

    public NMQ_N01_NCKNSTNSC getNCKNSTNSC() {
        return this.getTyped("NCKNSTNSC", NMQ_N01_NCKNSTNSC.class);
    }

    public NMQ_N01_NCKNSTNSC getNCKNSTNSC(int rep) {
        return this.getTyped("NCKNSTNSC", rep, NMQ_N01_NCKNSTNSC.class);
    }

    public int getNCKNSTNSCReps() {
        return this.getReps("NCKNSTNSC");
    }

    public List<NMQ_N01_NCKNSTNSC> getNCKNSTNSCAll() throws HL7Exception {
        return this.getAllAsList("NCKNSTNSC", NMQ_N01_NCKNSTNSC.class);
    }

    public void insertNCKNSTNSC(NMQ_N01_NCKNSTNSC structure, int rep) throws HL7Exception {
        super.insertRepetition("NCKNSTNSC", structure, rep);
    }

    public NMQ_N01_NCKNSTNSC insertNCKNSTNSC(int rep) throws HL7Exception {
        return (NMQ_N01_NCKNSTNSC)super.insertRepetition("NCKNSTNSC", rep);
    }

    public NMQ_N01_NCKNSTNSC removeNCKNSTNSC(int rep) throws HL7Exception {
        return (NMQ_N01_NCKNSTNSC)super.removeRepetition("NCKNSTNSC", rep);
    }
}

