/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.MFN_M05_MF_LOC_DEPT;
import ca.uhn.hl7v2.model.v24.segment.LCH;
import ca.uhn.hl7v2.model.v24.segment.LOC;
import ca.uhn.hl7v2.model.v24.segment.LRL;
import ca.uhn.hl7v2.model.v24.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M05_MF_LOCATION
extends AbstractGroup {
    public MFN_M05_MF_LOCATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(LOC.class, true, false, false);
            this.add(LCH.class, false, true, false);
            this.add(LRL.class, false, true, false);
            this.add(MFN_M05_MF_LOC_DEPT.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFN_M05_MF_LOCATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MFE getMFE() {
        MFE retVal = this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public LOC getLOC() {
        LOC retVal = this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LCH getLCH() {
        LCH retVal = this.getTyped("LCH", LCH.class);
        return retVal;
    }

    public LCH getLCH(int rep) {
        LCH retVal = this.getTyped("LCH", rep, LCH.class);
        return retVal;
    }

    public int getLCHReps() {
        return this.getReps("LCH");
    }

    public List<LCH> getLCHAll() throws HL7Exception {
        return this.getAllAsList("LCH", LCH.class);
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LRL getLRL() {
        LRL retVal = this.getTyped("LRL", LRL.class);
        return retVal;
    }

    public LRL getLRL(int rep) {
        LRL retVal = this.getTyped("LRL", rep, LRL.class);
        return retVal;
    }

    public int getLRLReps() {
        return this.getReps("LRL");
    }

    public List<LRL> getLRLAll() throws HL7Exception {
        return this.getAllAsList("LRL", LRL.class);
    }

    public void insertLRL(LRL structure, int rep) throws HL7Exception {
        super.insertRepetition("LRL", structure, rep);
    }

    public LRL insertLRL(int rep) throws HL7Exception {
        return (LRL)super.insertRepetition("LRL", rep);
    }

    public LRL removeLRL(int rep) throws HL7Exception {
        return (LRL)super.removeRepetition("LRL", rep);
    }

    public MFN_M05_MF_LOC_DEPT getMF_LOC_DEPT() {
        MFN_M05_MF_LOC_DEPT retVal = this.getTyped("MF_LOC_DEPT", MFN_M05_MF_LOC_DEPT.class);
        return retVal;
    }

    public MFN_M05_MF_LOC_DEPT getMF_LOC_DEPT(int rep) {
        MFN_M05_MF_LOC_DEPT retVal = this.getTyped("MF_LOC_DEPT", rep, MFN_M05_MF_LOC_DEPT.class);
        return retVal;
    }

    public int getMF_LOC_DEPTReps() {
        return this.getReps("MF_LOC_DEPT");
    }

    public List<MFN_M05_MF_LOC_DEPT> getMF_LOC_DEPTAll() throws HL7Exception {
        return this.getAllAsList("MF_LOC_DEPT", MFN_M05_MF_LOC_DEPT.class);
    }

    public void insertMF_LOC_DEPT(MFN_M05_MF_LOC_DEPT structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_LOC_DEPT", structure, rep);
    }

    public MFN_M05_MF_LOC_DEPT insertMF_LOC_DEPT(int rep) throws HL7Exception {
        return (MFN_M05_MF_LOC_DEPT)super.insertRepetition("MF_LOC_DEPT", rep);
    }

    public MFN_M05_MF_LOC_DEPT removeMF_LOC_DEPT(int rep) throws HL7Exception {
        return (MFN_M05_MF_LOC_DEPT)super.removeRepetition("MF_LOC_DEPT", rep);
    }
}

