/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.segment.AFF;
import ca.uhn.hl7v2.model.v24.segment.EDU;
import ca.uhn.hl7v2.model.v24.segment.LAN;
import ca.uhn.hl7v2.model.v24.segment.ORG;
import ca.uhn.hl7v2.model.v24.segment.PRA;
import ca.uhn.hl7v2.model.v24.segment.STF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_K25_STAFF
extends AbstractGroup {
    public RSP_K25_STAFF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(STF.class, true, false, false);
            this.add(PRA.class, false, false, false);
            this.add(ORG.class, false, true, false);
            this.add(AFF.class, false, true, false);
            this.add(LAN.class, false, true, false);
            this.add(EDU.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RSP_K25_STAFF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public STF getSTF() {
        STF retVal = this.getTyped("STF", STF.class);
        return retVal;
    }

    public PRA getPRA() {
        PRA retVal = this.getTyped("PRA", PRA.class);
        return retVal;
    }

    public ORG getORG() {
        ORG retVal = this.getTyped("ORG", ORG.class);
        return retVal;
    }

    public ORG getORG(int rep) {
        ORG retVal = this.getTyped("ORG", rep, ORG.class);
        return retVal;
    }

    public int getORGReps() {
        return this.getReps("ORG");
    }

    public List<ORG> getORGAll() throws HL7Exception {
        return this.getAllAsList("ORG", ORG.class);
    }

    public void insertORG(ORG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORG", structure, rep);
    }

    public ORG insertORG(int rep) throws HL7Exception {
        return (ORG)super.insertRepetition("ORG", rep);
    }

    public ORG removeORG(int rep) throws HL7Exception {
        return (ORG)super.removeRepetition("ORG", rep);
    }

    public AFF getAFF() {
        AFF retVal = this.getTyped("AFF", AFF.class);
        return retVal;
    }

    public AFF getAFF(int rep) {
        AFF retVal = this.getTyped("AFF", rep, AFF.class);
        return retVal;
    }

    public int getAFFReps() {
        return this.getReps("AFF");
    }

    public List<AFF> getAFFAll() throws HL7Exception {
        return this.getAllAsList("AFF", AFF.class);
    }

    public void insertAFF(AFF structure, int rep) throws HL7Exception {
        super.insertRepetition("AFF", structure, rep);
    }

    public AFF insertAFF(int rep) throws HL7Exception {
        return (AFF)super.insertRepetition("AFF", rep);
    }

    public AFF removeAFF(int rep) throws HL7Exception {
        return (AFF)super.removeRepetition("AFF", rep);
    }

    public LAN getLAN() {
        LAN retVal = this.getTyped("LAN", LAN.class);
        return retVal;
    }

    public LAN getLAN(int rep) {
        LAN retVal = this.getTyped("LAN", rep, LAN.class);
        return retVal;
    }

    public int getLANReps() {
        return this.getReps("LAN");
    }

    public List<LAN> getLANAll() throws HL7Exception {
        return this.getAllAsList("LAN", LAN.class);
    }

    public void insertLAN(LAN structure, int rep) throws HL7Exception {
        super.insertRepetition("LAN", structure, rep);
    }

    public LAN insertLAN(int rep) throws HL7Exception {
        return (LAN)super.insertRepetition("LAN", rep);
    }

    public LAN removeLAN(int rep) throws HL7Exception {
        return (LAN)super.removeRepetition("LAN", rep);
    }

    public EDU getEDU() {
        EDU retVal = this.getTyped("EDU", EDU.class);
        return retVal;
    }

    public EDU getEDU(int rep) {
        EDU retVal = this.getTyped("EDU", rep, EDU.class);
        return retVal;
    }

    public int getEDUReps() {
        return this.getReps("EDU");
    }

    public List<EDU> getEDUAll() throws HL7Exception {
        return this.getAllAsList("EDU", EDU.class);
    }

    public void insertEDU(EDU structure, int rep) throws HL7Exception {
        super.insertRepetition("EDU", structure, rep);
    }

    public EDU insertEDU(int rep) throws HL7Exception {
        return (EDU)super.insertRepetition("EDU", rep);
    }

    public EDU removeEDU(int rep) throws HL7Exception {
        return (EDU)super.removeRepetition("EDU", rep);
    }
}

