/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.SUR_P09_FACILITY_DETAIL;
import ca.uhn.hl7v2.model.v25.group.SUR_P09_PRODUCT;
import ca.uhn.hl7v2.model.v25.segment.FAC;
import ca.uhn.hl7v2.model.v25.segment.PSH;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUR_P09_FACILITY
extends AbstractGroup {
    public SUR_P09_FACILITY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(FAC.class, true, false, false);
            this.add(SUR_P09_PRODUCT.class, true, true, false);
            this.add(PSH.class, true, false, false);
            this.add(SUR_P09_FACILITY_DETAIL.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating SUR_P09_FACILITY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public FAC getFAC() {
        FAC retVal = this.getTyped("FAC", FAC.class);
        return retVal;
    }

    public SUR_P09_PRODUCT getPRODUCT() {
        SUR_P09_PRODUCT retVal = this.getTyped("PRODUCT", SUR_P09_PRODUCT.class);
        return retVal;
    }

    public SUR_P09_PRODUCT getPRODUCT(int rep) {
        SUR_P09_PRODUCT retVal = this.getTyped("PRODUCT", rep, SUR_P09_PRODUCT.class);
        return retVal;
    }

    public int getPRODUCTReps() {
        return this.getReps("PRODUCT");
    }

    public List<SUR_P09_PRODUCT> getPRODUCTAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT", SUR_P09_PRODUCT.class);
    }

    public void insertPRODUCT(SUR_P09_PRODUCT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT", structure, rep);
    }

    public SUR_P09_PRODUCT insertPRODUCT(int rep) throws HL7Exception {
        return (SUR_P09_PRODUCT)super.insertRepetition("PRODUCT", rep);
    }

    public SUR_P09_PRODUCT removePRODUCT(int rep) throws HL7Exception {
        return (SUR_P09_PRODUCT)super.removeRepetition("PRODUCT", rep);
    }

    public PSH getPSH() {
        PSH retVal = this.getTyped("PSH", PSH.class);
        return retVal;
    }

    public SUR_P09_FACILITY_DETAIL getFACILITY_DETAIL() {
        SUR_P09_FACILITY_DETAIL retVal = this.getTyped("FACILITY_DETAIL", SUR_P09_FACILITY_DETAIL.class);
        return retVal;
    }

    public SUR_P09_FACILITY_DETAIL getFACILITY_DETAIL(int rep) {
        SUR_P09_FACILITY_DETAIL retVal = this.getTyped("FACILITY_DETAIL", rep, SUR_P09_FACILITY_DETAIL.class);
        return retVal;
    }

    public int getFACILITY_DETAILReps() {
        return this.getReps("FACILITY_DETAIL");
    }

    public List<SUR_P09_FACILITY_DETAIL> getFACILITY_DETAILAll() throws HL7Exception {
        return this.getAllAsList("FACILITY_DETAIL", SUR_P09_FACILITY_DETAIL.class);
    }

    public void insertFACILITY_DETAIL(SUR_P09_FACILITY_DETAIL structure, int rep) throws HL7Exception {
        super.insertRepetition("FACILITY_DETAIL", structure, rep);
    }

    public SUR_P09_FACILITY_DETAIL insertFACILITY_DETAIL(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY_DETAIL)super.insertRepetition("FACILITY_DETAIL", rep);
    }

    public SUR_P09_FACILITY_DETAIL removeFACILITY_DETAIL(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY_DETAIL)super.removeRepetition("FACILITY_DETAIL", rep);
    }
}

