/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_TIMING;
import ca.uhn.hl7v2.model.v26.segment.DG1;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPL_O37_OBSERVATION_REQUEST
extends AbstractGroup {
    public OPL_O37_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(OBR.class, true, false, false);
            this.add(ROL.class, false, true, false);
            this.add(OPL_O37_TIMING.class, false, true, false);
            this.add(TCD.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OPL_O37_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public OPL_O37_TIMING getTIMING() {
        OPL_O37_TIMING retVal = this.getTyped("TIMING", OPL_O37_TIMING.class);
        return retVal;
    }

    public OPL_O37_TIMING getTIMING(int rep) {
        OPL_O37_TIMING retVal = this.getTyped("TIMING", rep, OPL_O37_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<OPL_O37_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", OPL_O37_TIMING.class);
    }

    public void insertTIMING(OPL_O37_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public OPL_O37_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OPL_O37_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OPL_O37_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OPL_O37_TIMING)super.removeRepetition("TIMING", rep);
    }

    public TCD getTCD() {
        TCD retVal = this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

