/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.RQA_I08_RESULTS;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RQA_I08_OBSERVATION
extends AbstractGroup {
    public RQA_I08_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RQA_I08_RESULTS.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RQA_I08_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RQA_I08_RESULTS getRESULTS() {
        RQA_I08_RESULTS retVal = this.getTyped("RESULTS", RQA_I08_RESULTS.class);
        return retVal;
    }

    public RQA_I08_RESULTS getRESULTS(int rep) {
        RQA_I08_RESULTS retVal = this.getTyped("RESULTS", rep, RQA_I08_RESULTS.class);
        return retVal;
    }

    public int getRESULTSReps() {
        return this.getReps("RESULTS");
    }

    public List<RQA_I08_RESULTS> getRESULTSAll() throws HL7Exception {
        return this.getAllAsList("RESULTS", RQA_I08_RESULTS.class);
    }

    public void insertRESULTS(RQA_I08_RESULTS structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS", structure, rep);
    }

    public RQA_I08_RESULTS insertRESULTS(int rep) throws HL7Exception {
        return (RQA_I08_RESULTS)super.insertRepetition("RESULTS", rep);
    }

    public RQA_I08_RESULTS removeRESULTS(int rep) throws HL7Exception {
        return (RQA_I08_RESULTS)super.removeRepetition("RESULTS", rep);
    }
}

