/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.RPI_I01_GUARANTOR_INSURANCE;
import ca.uhn.hl7v2.model.v26.group.RPI_I01_PROVIDER;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPI_I01
extends AbstractMessage {
    public RPI_I01() {
        this(new DefaultModelClassFactory());
    }

    public RPI_I01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(RPI_I01_PROVIDER.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(RPI_I01_GUARANTOR_INSURANCE.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RPI_I01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public RPI_I01_PROVIDER getPROVIDER() {
        return this.getTyped("PROVIDER", RPI_I01_PROVIDER.class);
    }

    public RPI_I01_PROVIDER getPROVIDER(int rep) {
        return this.getTyped("PROVIDER", rep, RPI_I01_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RPI_I01_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RPI_I01_PROVIDER.class);
    }

    public void insertPROVIDER(RPI_I01_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", structure, rep);
    }

    public RPI_I01_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RPI_I01_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RPI_I01_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RPI_I01_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public RPI_I01_GUARANTOR_INSURANCE getGUARANTOR_INSURANCE() {
        return this.getTyped("GUARANTOR_INSURANCE", RPI_I01_GUARANTOR_INSURANCE.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

